/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.textures;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.textures.ITextureAtlasSpriteLoader;

public final class ForgeTextureMetadata {
    public static final ForgeTextureMetadata EMPTY = new ForgeTextureMetadata(null);
    public static final MetadataSectionSerializer<ForgeTextureMetadata> SERIALIZER = new Serializer();
    @Nullable
    private final ITextureAtlasSpriteLoader loader;

    public static ForgeTextureMetadata forResource(Resource resource) {
        ForgeTextureMetadata metadata = (ForgeTextureMetadata)resource.m_5507_(SERIALIZER);
        return metadata == null ? EMPTY : metadata;
    }

    public ForgeTextureMetadata(@Nullable ITextureAtlasSpriteLoader loader) {
        this.loader = loader;
    }

    @Nullable
    public ITextureAtlasSpriteLoader getLoader() {
        return this.loader;
    }

    private static final class Serializer
    implements MetadataSectionSerializer<ForgeTextureMetadata> {
        private Serializer() {
        }

        @Nonnull
        public String m_7991_() {
            return "forge";
        }

        @Nonnull
        public ForgeTextureMetadata fromJson(JsonObject json) {
            ITextureAtlasSpriteLoader loader;
            if (json.has("loader")) {
                ResourceLocation loaderName = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"loader"));
                loader = MinecraftForgeClient.getTextureAtlasSpriteLoader(loaderName);
                if (loader == null) {
                    throw new JsonSyntaxException("Unknown TextureAtlasSpriteLoader " + String.valueOf(loaderName));
                }
            } else {
                loader = null;
            }
            return new ForgeTextureMetadata(loader);
        }
    }
}

