/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.generators.loaders;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.generators.CustomLoaderBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ItemLayersModelBuilder<T extends ModelBuilder<T>>
extends CustomLoaderBuilder<T> {
    private final Set<Integer> fullbright = new LinkedHashSet<Integer>();

    public static <T extends ModelBuilder<T>> ItemLayersModelBuilder<T> begin(T parent, ExistingFileHelper existingFileHelper) {
        return new ItemLayersModelBuilder<T>(parent, existingFileHelper);
    }

    protected ItemLayersModelBuilder(T parent, ExistingFileHelper existingFileHelper) {
        super(new ResourceLocation("forge:item-layers"), parent, existingFileHelper);
    }

    public ItemLayersModelBuilder<T> fullbright(int layer) {
        Preconditions.checkArgument((layer >= 0 ? 1 : 0) != 0, (Object)"layer must be >= 0");
        this.fullbright.add(layer);
        return this;
    }

    @Override
    public JsonObject toJson(JsonObject json) {
        json = super.toJson(json);
        JsonArray parts = new JsonArray();
        for (int entry : this.fullbright) {
            parts.add((Number)entry);
        }
        json.add("fullbright_layers", (JsonElement)parts);
        return json;
    }
}

