/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.client.model.geometry.IModelGeometryPart;

public class BlockModelConfiguration
implements IModelConfiguration {
    public final BlockModel owner;
    public final VisibilityData visibilityData = new VisibilityData();
    @Nullable
    private IModelGeometry<?> customGeometry;
    @Nullable
    private ModelState customModelState;

    public BlockModelConfiguration(BlockModel owner) {
        this.owner = owner;
    }

    @Override
    @Nullable
    public UnbakedModel getOwnerModel() {
        return this.owner;
    }

    @Override
    public String getModelName() {
        return this.owner.f_111416_;
    }

    public boolean hasCustomGeometry() {
        return this.getCustomGeometry() != null;
    }

    @Nullable
    public IModelGeometry<?> getCustomGeometry() {
        return this.owner.f_111418_ != null && this.customGeometry == null ? this.owner.f_111418_.customData.getCustomGeometry() : this.customGeometry;
    }

    public void setCustomGeometry(IModelGeometry<?> geometry) {
        this.customGeometry = geometry;
    }

    @Nullable
    public ModelState getCustomModelState() {
        return this.owner.f_111418_ != null && this.customModelState == null ? this.owner.f_111418_.customData.getCustomModelState() : this.customModelState;
    }

    public void setCustomModelState(ModelState modelState) {
        this.customModelState = modelState;
    }

    @Override
    public boolean getPartVisibility(IModelGeometryPart part, boolean fallback) {
        return this.owner.f_111418_ != null && !this.visibilityData.hasCustomVisibility(part) ? this.owner.f_111418_.customData.getPartVisibility(part, fallback) : this.visibilityData.isVisible(part, fallback);
    }

    @Override
    public boolean isTexturePresent(String name) {
        return this.owner.m_111477_(name);
    }

    @Override
    public Material resolveTexture(String name) {
        return this.owner.m_111480_(name);
    }

    @Override
    public boolean isShadedInGui() {
        return true;
    }

    @Override
    public boolean isSideLit() {
        return this.owner.m_111479_().m_111526_();
    }

    @Override
    public boolean useSmoothLighting() {
        return this.owner.m_111476_();
    }

    @Override
    public ItemTransforms getCameraTransforms() {
        return this.owner.m_111491_();
    }

    @Override
    public ModelState getCombinedTransform() {
        ModelState state = this.getCustomModelState();
        return state != null ? new SimpleModelState(PerspectiveMapWrapper.getTransformsWithFallback(state, this.getCameraTransforms()), state.m_6189_()) : new SimpleModelState(PerspectiveMapWrapper.getTransforms(this.getCameraTransforms()));
    }

    public void copyFrom(BlockModelConfiguration other) {
        this.customGeometry = other.customGeometry;
        this.customModelState = other.customModelState;
        this.visibilityData.copyFrom(other.visibilityData);
    }

    public Collection<Material> getTextureDependencies(Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        IModelGeometry<?> geometry = this.getCustomGeometry();
        return geometry == null ? Collections.emptySet() : geometry.getTextures(this, modelGetter, missingTextureErrors);
    }

    public BakedModel bake(ModelBakery bakery, Function<Material, TextureAtlasSprite> bakedTextureGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        IModelGeometry<?> geometry = this.getCustomGeometry();
        if (geometry == null) {
            throw new IllegalStateException("Can not use custom baking without custom geometry");
        }
        return geometry.bake(this, bakery, bakedTextureGetter, modelTransform, overrides, modelLocation);
    }

    public static class VisibilityData {
        private final Map<String, Boolean> data = new HashMap<String, Boolean>();

        public boolean hasCustomVisibility(IModelGeometryPart part) {
            return this.data.containsKey(part.name());
        }

        public boolean isVisible(IModelGeometryPart part, boolean fallback) {
            return this.data.getOrDefault(part.name(), fallback);
        }

        public void setVisibilityState(String partName, boolean type) {
            this.data.put(partName, type);
        }

        public void copyFrom(VisibilityData visibilityData) {
            this.data.clear();
            this.data.putAll(visibilityData.data);
        }
    }
}

