/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.jar.Manifest;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileParser;
import net.minecraftforge.fml.loading.moddiscovery.ModJarMetadata;
import net.minecraftforge.forgespi.language.IConfigurable;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractModLocator
implements IModLocator {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final String MODS_TOML = "META-INF/mods.toml";
    protected static final String MANIFEST = "META-INF/MANIFEST.MF";

    protected Optional<IModFile> createMod(Path ... path) {
        return this.createMod(this.getDefaultJarModType(), path);
    }

    protected Optional<IModFile> createMod(String defaultType, Path ... path) {
        ModFile mod;
        ModJarMetadata mjm = new ModJarMetadata();
        SecureJar sj = SecureJar.from(Manifest::new, jar -> jar.findFile(MODS_TOML).isPresent() ? mjm : JarMetadata.from((SecureJar)jar, (Path[])path), (root, p) -> true, (Path[])path);
        String type = sj.getManifest().getMainAttributes().getValue(ModFile.TYPE);
        if (type == null) {
            type = defaultType;
        }
        if (sj.findFile(MODS_TOML).isPresent()) {
            LOGGER.debug(LogMarkers.SCAN, "Found {} mod of type {}: {}", (Object)MODS_TOML, (Object)type, (Object)path);
            mod = new ModFile(sj, this, ModFileParser::modsTomlParser);
        } else if (type != null) {
            LOGGER.debug(LogMarkers.SCAN, "Found {} mod of type {}: {}", (Object)MANIFEST, (Object)type, (Object)path);
            mod = new ModFile(sj, this, this::manifestParser, type);
        } else {
            return Optional.empty();
        }
        mjm.setModFile(mod);
        return Optional.of(mod);
    }

    protected IModFileInfo manifestParser(IModFile mod) {
        Function<String, Optional> cfg = name -> Optional.ofNullable(mod.getSecureJar().getManifest().getMainAttributes().getValue((String)name));
        String license = cfg.apply("LICENSE").orElse("");
        IConfigurable dummy = new IConfigurable(){

            public <T> Optional<T> getConfigElement(String ... key) {
                return Optional.empty();
            }

            public List<? extends IConfigurable> getConfigList(String ... key) {
                return Collections.emptyList();
            }
        };
        return new DefaultModFileInfo(mod, license, dummy);
    }

    public boolean isValid(IModFile modFile) {
        return true;
    }

    protected String getDefaultJarModType() {
        return null;
    }

    private record DefaultModFileInfo(IModFile mod, String license, IConfigurable configurable) implements IModFileInfo,
    IConfigurable
    {
        public <T> Optional<T> getConfigElement(String ... strings) {
            return Optional.empty();
        }

        public List<? extends IConfigurable> getConfigList(String ... strings) {
            return null;
        }

        public List<IModInfo> getMods() {
            return Collections.emptyList();
        }

        public List<IModFileInfo.LanguageSpec> requiredLanguageLoaders() {
            return Collections.emptyList();
        }

        public boolean showAsResourcePack() {
            return false;
        }

        public Map<String, Object> getFileProperties() {
            return Collections.emptyMap();
        }

        public String getLicense() {
            return this.license;
        }

        public IModFile getFile() {
            return this.mod;
        }

        public IConfigurable getConfig() {
            return this.configurable;
        }

        public String moduleName() {
            return this.mod.getSecureJar().name();
        }

        public String versionString() {
            return null;
        }

        public List<String> usesServices() {
            return null;
        }

        @Override
        public String toString() {
            return "IModFileInfo(" + String.valueOf(this.mod.getFilePath()) + ")";
        }
    }
}

