/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.jarjar.nio.layzip;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraftforge.jarjar.nio.pathfs.PathFileSystemProvider;
import net.minecraftforge.jarjar.nio.pathfs.PathPath;

public class LayeredZipFileSystemProvider
extends PathFileSystemProvider {
    public static final String SCHEME = "jij";
    public static final String URI_SPLIT_REGEX = "~";

    @Override
    public String getScheme() {
        return SCHEME;
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        String lastSection;
        String[] sections = uri.getRawSchemeSpecificPart().split(URI_SPLIT_REGEX);
        FileSystem workingSystem = FileSystems.getDefault();
        String keyPrefix = "";
        if (sections.length > 1) {
            AdaptedURIWithPrefixSelection adaptedURI = this.adaptUriSections(sections);
            keyPrefix = adaptedURI.getPrefix();
            workingSystem = adaptedURI.getFileSystem();
        }
        if ((lastSection = sections[sections.length - 1]).startsWith("//")) {
            lastSection = lastSection.substring(2);
        }
        if (env.containsKey("packagePath")) {
            try {
                return super.newFileSystem(new URI(super.getScheme() + ":" + uri.getRawSchemeSpecificPart()), env);
            }
            catch (Exception e) {
                throw new UncheckedIOException("Failed to create intermediary FS.", new IOException("Failed to process data.", e));
            }
        }
        Path lastPath = workingSystem.getPath(lastSection, new String[0]).toAbsolutePath();
        return this.getOrCreateNewSystem(keyPrefix, lastPath);
    }

    private String handleAbsolutePrefixOnWindows(FileSystem workingSystem, String section) {
        if (workingSystem.getClass().getName().toLowerCase(Locale.ROOT).contains("windows") && section.startsWith("/")) {
            section = section.substring(1);
        }
        return section;
    }

    private FileSystem getOrCreateNewSystem(Path path) {
        return this.getOrCreateNewSystem("", path);
    }

    private FileSystem getOrCreateNewSystem(String keyPrefix, Path path) {
        HashMap<String, Path> args = new HashMap<String, Path>();
        args.put("packagePath", path.toAbsolutePath());
        try {
            return super.newFileSystem(new URI(super.getScheme() + ":" + keyPrefix + path.toString().replace("\\", "/")), args);
        }
        catch (Exception e) {
            throw new UncheckedIOException("Failed to create intermediary FS.", new IOException("Failed to process data.", e));
        }
    }

    @Override
    public Path getPath(URI uri) {
        String[] sections = uri.getRawSchemeSpecificPart().split(URI_SPLIT_REGEX);
        if (sections.length == 1) {
            return super.getPath(uri);
        }
        FileSystem workingSystem = FileSystems.getDefault();
        if (sections.length > 1) {
            for (int i = 0; i < sections.length - 1; ++i) {
                String section = sections[i];
                Path path = workingSystem.getPath(section, new String[0]);
                workingSystem = this.getOrCreateNewSystem(path);
            }
        }
        String lastSection = sections[sections.length - 1];
        return workingSystem.getPath(lastSection, new String[0]);
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        String[] sections = uri.getRawSchemeSpecificPart().split(URI_SPLIT_REGEX);
        if (sections.length == 1) {
            return super.getFileSystem(uri);
        }
        FileSystem workingSystem = FileSystems.getDefault();
        if (sections.length > 1) {
            for (int i = 0; i < sections.length - 1; ++i) {
                String section = sections[i];
                Path path = workingSystem.getPath(section, new String[0]);
                workingSystem = this.getOrCreateNewSystem(path);
            }
        }
        String lastSection = sections[sections.length - 1];
        Path lastPath = workingSystem.getPath(lastSection, new String[0]);
        return this.getOrCreateNewSystem(lastPath);
    }

    @Override
    protected URI buildUriFor(PathPath path) throws URISyntaxException, IllegalArgumentException {
        String prefix = "";
        prefix = this.buildPrefixFor(path.getFileSystem().getTarget());
        return URI.create(String.format("%s:%s%s", SCHEME, prefix, path).replace(String.format("%s/", "~/"), "~/"));
    }

    protected String buildPrefixFor(Path path) {
        if (path instanceof PathPath) {
            return this.buildPrefixFor(((PathPath)path).getFileSystem().getTarget()) + "~/" + path.toAbsolutePath();
        }
        return path.toAbsolutePath().toUri().getRawSchemeSpecificPart();
    }

    @Override
    public Path adaptResolvedPath(PathPath path) {
        if (!path.toString().contains("~/")) {
            return path;
        }
        Path workingPath = path.getFileSystem().getPath(path.toString().substring(0, path.toString().lastIndexOf("~/")) + "~/", new String[0]);
        try {
            FileSystem workingSystem = FileSystems.newFileSystem(workingPath.toUri(), new HashMap());
            return workingSystem.getPath(path.endsWith("~/") ? "/" : path.toString().substring(path.toString().lastIndexOf("~/") + 2), new String[0]);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to get sub file system for path!", e);
        }
    }

    @Override
    public String[] adaptPathParts(String longstring, String[] pathParts) {
        if (!longstring.endsWith("~/")) {
            return pathParts;
        }
        pathParts[pathParts.length - 1] = pathParts[pathParts.length - 1] + "/";
        return pathParts;
    }

    private AdaptedURIWithPrefixSelection adaptUriSections(String[] sections) {
        String keyPrefix = "";
        FileSystem workingSystem = FileSystems.getDefault();
        Optional<FileSystem> rootKnownCandidateSystem = super.getFileSystemFromKey(sections[0]);
        if (rootKnownCandidateSystem.isPresent()) {
            if (sections.length == 1) {
                return new AdaptedURIWithPrefixSelection(rootKnownCandidateSystem.get(), sections[0]);
            }
            workingSystem = rootKnownCandidateSystem.get();
            keyPrefix = keyPrefix + sections[0].replace("\\", "/") + "~/";
            for (int i = 1; i < sections.length - 2; ++i) {
                String section = sections[i];
                if (section.startsWith("/")) {
                    section = section.substring(1);
                }
                Path path = workingSystem.getPath(section, new String[0]).toAbsolutePath();
                workingSystem = this.getOrCreateNewSystem(keyPrefix, path);
                keyPrefix = keyPrefix + path.toString().replace("\\", "/") + "~/";
            }
            return new AdaptedURIWithPrefixSelection(workingSystem, sections[sections.length - 1]);
        }
        for (int i = 0; i < sections.length - 1; ++i) {
            String section = sections[i];
            if (section.startsWith("//")) {
                section = section.substring(2);
            }
            section = this.handleAbsolutePrefixOnWindows(workingSystem, section);
            Path path = workingSystem.getPath(section, new String[0]).toAbsolutePath();
            workingSystem = this.getOrCreateNewSystem(keyPrefix, path);
            keyPrefix = keyPrefix + path.toString().replace("\\", "/") + "~/";
        }
        return new AdaptedURIWithPrefixSelection(workingSystem, keyPrefix);
    }

    private final class AdaptedURIWithPrefixSelection {
        private final String prefix;
        private final FileSystem fileSystem;

        private AdaptedURIWithPrefixSelection(FileSystem fileSystem, String prefix) {
            this.prefix = prefix;
            this.fileSystem = fileSystem;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public FileSystem getFileSystem() {
            return this.fileSystem;
        }
    }
}

