/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.modlauncher.ArgumentHandler;
import cpw.mods.modlauncher.LaunchPluginHandler;
import cpw.mods.modlauncher.LaunchServiceHandlerDecorator;
import cpw.mods.modlauncher.LogMarkers;
import cpw.mods.modlauncher.ModuleLayerHandler;
import cpw.mods.modlauncher.TransformingClassLoader;
import cpw.mods.modlauncher.TransformingClassLoaderBuilder;
import cpw.mods.modlauncher.api.ILaunchHandlerService;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.NamedPath;
import cpw.mods.modlauncher.util.ServiceLoaderUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

class LaunchServiceHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<String, LaunchServiceHandlerDecorator> launchHandlerLookup = ServiceLoaderUtils.streamServiceLoader(() -> ServiceLoader.load(layerHandler.getLayer(IModuleLayerManager.Layer.BOOT).orElseThrow(), ILaunchHandlerService.class), sce -> LOGGER.fatal("Encountered serious error loading transformation service, expect problems", (Throwable)sce)).collect(Collectors.toMap(ILaunchHandlerService::name, LaunchServiceHandlerDecorator::new));

    public LaunchServiceHandler(ModuleLayerHandler layerHandler) {
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Found launch services [{}]", new Supplier[]{() -> String.join((CharSequence)",", this.launchHandlerLookup.keySet())});
    }

    public Optional<ILaunchHandlerService> findLaunchHandler(String name) {
        return Optional.ofNullable(this.launchHandlerLookup.getOrDefault(name, null)).map(LaunchServiceHandlerDecorator::getService);
    }

    private void launch(String target, String[] arguments, ModuleLayer gameLayer, TransformingClassLoader classLoader, LaunchPluginHandler launchPluginHandler) {
        LaunchServiceHandlerDecorator launchServiceHandlerDecorator = this.launchHandlerLookup.get(target);
        NamedPath[] paths = launchServiceHandlerDecorator.getService().getPaths();
        launchPluginHandler.announceLaunch(classLoader, paths);
        LOGGER.info(LogMarkers.MODLAUNCHER, "Launching target '{}' with arguments {}", (Object)target, LaunchServiceHandler.hideAccessToken(arguments));
        launchServiceHandlerDecorator.launch(arguments, gameLayer);
    }

    static List<String> hideAccessToken(String[] arguments) {
        ArrayList<String> output = new ArrayList<String>();
        for (int i = 0; i < arguments.length; ++i) {
            if (i > 0 && Objects.equals(arguments[i - 1], "--accessToken")) {
                output.add("\u2744\u2744\u2744\u2744\u2744\u2744\u2744\u2744");
                continue;
            }
            output.add(arguments[i]);
        }
        return output;
    }

    public void launch(ArgumentHandler argumentHandler, ModuleLayer gameLayer, TransformingClassLoader classLoader, LaunchPluginHandler launchPluginHandler) {
        String launchTarget = argumentHandler.getLaunchTarget();
        String[] args = argumentHandler.buildArgumentList();
        this.launch(launchTarget, args, gameLayer, classLoader, launchPluginHandler);
    }

    TransformingClassLoaderBuilder identifyTransformationTargets(ArgumentHandler argumentHandler) {
        String launchTarget = argumentHandler.getLaunchTarget();
        TransformingClassLoaderBuilder builder = new TransformingClassLoaderBuilder();
        Arrays.stream(argumentHandler.getSpecialJars()).forEach(builder::addTransformationPath);
        this.launchHandlerLookup.get(launchTarget).configureTransformationClassLoaderBuilder(builder);
        return builder;
    }

    void validateLaunchTarget(ArgumentHandler argumentHandler) {
        if (!this.launchHandlerLookup.containsKey(argumentHandler.getLaunchTarget())) {
            LOGGER.error(LogMarkers.MODLAUNCHER, "Cannot find launch target {}, unable to launch", (Object)argumentHandler.getLaunchTarget());
            throw new RuntimeException("Cannot find launch target");
        }
    }
}

