/*
 * Decompiled with CFR 0.152.
 */
package com.nightgames.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerNumberStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"NightGames-PlayerNumbers");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type TYPE = new TypeToken<Map<UUID, Integer>>(){}.getType();

    private static File getFile(MinecraftServer server) {
        return new File(server.method_27050(class_5218.field_24188).toFile(), "nightgames/player_numbers.json");
    }

    public static Map<UUID, Integer> load(MinecraftServer server) {
        Map map;
        File file = PlayerNumberStorage.getFile(server);
        if (!file.exists()) {
            LOGGER.info("[NightGames] No player_numbers.json found, starting fresh.");
            return new HashMap<UUID, Integer>();
        }
        FileReader reader = new FileReader(file);
        try {
            map = (Map)GSON.fromJson((Reader)reader, TYPE);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.error("[NightGames] Failed to load player numbers", (Throwable)e);
                return new HashMap<UUID, Integer>();
            }
        }
        reader.close();
        return map;
    }

    public static void save(MinecraftServer server, Map<UUID, Integer> data) {
        boolean created;
        File file = PlayerNumberStorage.getFile(server);
        File parent = file.getParentFile();
        if (!parent.exists() && !(created = parent.mkdirs())) {
            LOGGER.error("[NightGames] Failed to create directory: {}", (Object)parent.getAbsolutePath());
            return;
        }
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson(data, (Appendable)writer);
        }
        catch (Exception e) {
            LOGGER.error("[NightGames] Failed to save player numbers", (Throwable)e);
        }
    }
}

