/*
 * Decompiled with CFR 0.152.
 */
package com.nightgames.server;

import com.nightgames.server.PlayerNumberStorage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_268;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class PlayerNumberManager {
    private static final int MAX_NUMBERS = 150;
    private static final Map<UUID, Integer> playerNumbers = new HashMap<UUID, Integer>();
    private static final Set<Integer> usedNumbers = new HashSet<Integer>();

    public static void load(MinecraftServer server) {
        playerNumbers.clear();
        usedNumbers.clear();
        Map<UUID, Integer> loaded = PlayerNumberStorage.load(server);
        playerNumbers.putAll(loaded);
        usedNumbers.addAll(loaded.values());
    }

    public static int getNumber(class_3222 player) {
        return playerNumbers.getOrDefault(player.method_5667(), -1);
    }

    public static void assignNumber(class_3222 player) {
        class_268 team = player.method_5781();
        if (team != null && team.method_1197().equalsIgnoreCase("admin")) {
            playerNumbers.put(player.method_5667(), 0);
            return;
        }
        if (playerNumbers.containsKey(player.method_5667())) {
            return;
        }
        for (int i = 1; i <= 150; ++i) {
            if (usedNumbers.contains(i)) continue;
            playerNumbers.put(player.method_5667(), i);
            usedNumbers.add(i);
            return;
        }
        throw new IllegalStateException("No hay n\u00fameros disponibles");
    }

    public static void save(MinecraftServer server) {
        PlayerNumberStorage.save(server, playerNumbers);
    }
}

