/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.BastionFeature;
import net.minecraft.world.level.levelgen.feature.BuriedTreasureFeature;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.DesertPyramidFeature;
import net.minecraft.world.level.levelgen.feature.EndCityFeature;
import net.minecraft.world.level.levelgen.feature.IglooFeature;
import net.minecraft.world.level.levelgen.feature.JunglePyramidFeature;
import net.minecraft.world.level.levelgen.feature.MineshaftFeature;
import net.minecraft.world.level.levelgen.feature.NetherFortressFeature;
import net.minecraft.world.level.levelgen.feature.OceanMonumentFeature;
import net.minecraft.world.level.levelgen.feature.PillagerOutpostFeature;
import net.minecraft.world.level.levelgen.feature.RuinedPortalFeature;
import net.minecraft.world.level.levelgen.feature.ShipwreckFeature;
import net.minecraft.world.level.levelgen.feature.StrongholdFeature;
import net.minecraft.world.level.levelgen.feature.SwamplandHutFeature;
import net.minecraft.world.level.levelgen.feature.VillageFeature;
import net.minecraft.world.level.levelgen.feature.WoodlandMansionFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.MineshaftConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OceanRuinConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ProbabilityFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RangeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RuinedPortalConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ShipwreckConfiguration;
import net.minecraft.world.level.levelgen.structure.NetherFossilFeature;
import net.minecraft.world.level.levelgen.structure.OceanRuinFeature;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.slf4j.Logger;

public abstract class StructureFeature<C extends FeatureConfiguration>
extends ForgeRegistryEntry<StructureFeature<?>> {
    private static final Map<StructureFeature<?>, GenerationStep.Decoration> f_67032_ = Maps.newHashMap();
    private static final Logger f_67033_ = LogUtils.getLogger();
    public static final StructureFeature<JigsawConfiguration> f_67013_ = StructureFeature.m_67089_("pillager_outpost", new PillagerOutpostFeature(JigsawConfiguration.f_67756_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<MineshaftConfiguration> f_67014_ = StructureFeature.m_67089_("mineshaft", new MineshaftFeature(MineshaftConfiguration.f_67780_), GenerationStep.Decoration.UNDERGROUND_STRUCTURES);
    public static final StructureFeature<NoneFeatureConfiguration> f_67015_ = StructureFeature.m_67089_("mansion", new WoodlandMansionFeature(NoneFeatureConfiguration.f_67815_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<NoneFeatureConfiguration> f_67016_ = StructureFeature.m_67089_("jungle_pyramid", new JunglePyramidFeature(NoneFeatureConfiguration.f_67815_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<NoneFeatureConfiguration> f_67017_ = StructureFeature.m_67089_("desert_pyramid", new DesertPyramidFeature(NoneFeatureConfiguration.f_67815_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<NoneFeatureConfiguration> f_67018_ = StructureFeature.m_67089_("igloo", new IglooFeature(NoneFeatureConfiguration.f_67815_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<RuinedPortalConfiguration> f_67019_ = StructureFeature.m_67089_("ruined_portal", new RuinedPortalFeature(RuinedPortalConfiguration.f_68054_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<ShipwreckConfiguration> f_67020_ = StructureFeature.m_67089_("shipwreck", new ShipwreckFeature(ShipwreckConfiguration.f_68061_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<NoneFeatureConfiguration> f_67021_ = StructureFeature.m_67089_("swamp_hut", new SwamplandHutFeature(NoneFeatureConfiguration.f_67815_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<NoneFeatureConfiguration> f_67022_ = StructureFeature.m_67089_("stronghold", new StrongholdFeature(NoneFeatureConfiguration.f_67815_), GenerationStep.Decoration.STRONGHOLDS);
    public static final StructureFeature<NoneFeatureConfiguration> f_67023_ = StructureFeature.m_67089_("monument", new OceanMonumentFeature(NoneFeatureConfiguration.f_67815_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<OceanRuinConfiguration> f_67024_ = StructureFeature.m_67089_("ocean_ruin", new OceanRuinFeature(OceanRuinConfiguration.f_67820_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<NoneFeatureConfiguration> f_209756_ = StructureFeature.m_67089_("fortress", new NetherFortressFeature(NoneFeatureConfiguration.f_67815_), GenerationStep.Decoration.UNDERGROUND_DECORATION);
    public static final StructureFeature<NoneFeatureConfiguration> f_67026_ = StructureFeature.m_67089_("endcity", new EndCityFeature(NoneFeatureConfiguration.f_67815_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<ProbabilityFeatureConfiguration> f_67027_ = StructureFeature.m_67089_("buried_treasure", new BuriedTreasureFeature(ProbabilityFeatureConfiguration.f_67858_), GenerationStep.Decoration.UNDERGROUND_STRUCTURES);
    public static final StructureFeature<JigsawConfiguration> f_67028_ = StructureFeature.m_67089_("village", new VillageFeature(JigsawConfiguration.f_67756_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<RangeConfiguration> f_67029_ = StructureFeature.m_67089_("nether_fossil", new NetherFossilFeature(RangeConfiguration.f_191320_), GenerationStep.Decoration.UNDERGROUND_DECORATION);
    public static final StructureFeature<JigsawConfiguration> f_67030_ = StructureFeature.m_67089_("bastion_remnant", new BastionFeature(JigsawConfiguration.f_67756_), GenerationStep.Decoration.SURFACE_STRUCTURES);
    public static final int f_160446_ = 8;
    private final Codec<ConfiguredStructureFeature<C, StructureFeature<C>>> f_67036_ = RecordCodecBuilder.create(p_209759_ -> p_209759_.group((App)p_197168_.fieldOf("config").forGetter(p_209786_ -> p_209786_.f_65404_), (App)RegistryCodecs.m_206277_(Registry.f_122885_).fieldOf("biomes").forGetter(ConfiguredStructureFeature::m_209752_), (App)Codec.BOOL.optionalFieldOf("adapt_noise", (Object)false).forGetter(p_209784_ -> p_209784_.f_209745_), (App)Codec.simpleMap(MobCategory.f_21584_, (Codec)StructureSpawnOverride.f_210042_, (Keyable)StringRepresentable.m_14357_((StringRepresentable[])MobCategory.values())).fieldOf("spawn_overrides").forGetter(p_209761_ -> p_209761_.f_209744_)).apply((Applicative)p_209759_, (p_209779_, p_209780_, p_209781_, p_209782_) -> new ConfiguredStructureFeature(this, p_209779_, p_209780_, p_209781_.booleanValue(), p_209782_)));
    private final PieceGeneratorSupplier<C> f_191106_;
    private final PostPlacementProcessor f_191107_;

    private static <F extends StructureFeature<?>> F m_67089_(String p_67090_, F p_67091_, GenerationStep.Decoration p_67092_) {
        f_67032_.put(p_67091_, p_67092_);
        return (F)((Object)Registry.m_122961_(Registry.f_122841_, p_67090_, p_67091_));
    }

    public StructureFeature(Codec<C> p_197165_, PieceGeneratorSupplier<C> p_197166_) {
        this(p_197165_, p_197166_, PostPlacementProcessor.f_192427_);
    }

    public StructureFeature(Codec<C> p_197168_, PieceGeneratorSupplier<C> p_197169_, PostPlacementProcessor p_197170_) {
        this.f_191106_ = p_197169_;
        this.f_191107_ = p_197170_;
    }

    public GenerationStep.Decoration m_67095_() {
        return f_67032_.get((Object)this);
    }

    public static void m_67096_() {
    }

    @Nullable
    public static StructureStart m_191128_(StructurePieceSerializationContext p_191129_, CompoundTag p_191130_, long p_191131_) {
        String s = p_191130_.m_128461_("id");
        if ("INVALID".equals(s)) {
            return StructureStart.f_73561_;
        }
        Registry<ConfiguredStructureFeature<?, ?>> registry = p_191129_.f_192763_().m_175515_(Registry.f_122882_);
        ConfiguredStructureFeature<?, ?> configuredstructurefeature = registry.m_7745_(new ResourceLocation(s));
        if (configuredstructurefeature == null) {
            f_67033_.error("Unknown feature id: {}", (Object)s);
            return null;
        }
        ChunkPos chunkpos = new ChunkPos(p_191130_.m_128451_("ChunkX"), p_191130_.m_128451_("ChunkZ"));
        int i = p_191130_.m_128451_("references");
        ListTag listtag = p_191130_.m_128437_("Children", 10);
        try {
            PiecesContainer piecescontainer = PiecesContainer.m_192753_((ListTag)listtag, (StructurePieceSerializationContext)p_191129_);
            if (configuredstructurefeature.f_65403_ == f_67023_) {
                piecescontainer = OceanMonumentFeature.m_191020_((ChunkPos)chunkpos, (long)p_191131_, (PiecesContainer)piecescontainer);
            }
            return new StructureStart(configuredstructurefeature, chunkpos, i, piecescontainer);
        }
        catch (Exception exception) {
            f_67033_.error("Failed Start with id {}", (Object)s, (Object)exception);
            return null;
        }
    }

    public Codec<ConfiguredStructureFeature<C, StructureFeature<C>>> m_67097_() {
        return this.f_67036_;
    }

    public ConfiguredStructureFeature<C, ? extends StructureFeature<C>> m_209762_(C p_209763_, TagKey<Biome> p_209764_) {
        return this.m_209769_(p_209763_, p_209764_, false);
    }

    public ConfiguredStructureFeature<C, ? extends StructureFeature<C>> m_209769_(C p_209770_, TagKey<Biome> p_209771_, boolean p_209772_) {
        return new ConfiguredStructureFeature(this, p_209770_, BuiltinRegistries.f_123865_.m_203561_(p_209771_), p_209772_, Map.of());
    }

    public ConfiguredStructureFeature<C, ? extends StructureFeature<C>> m_209765_(C p_209766_, TagKey<Biome> p_209767_, Map<MobCategory, StructureSpawnOverride> p_209768_) {
        return new ConfiguredStructureFeature(this, p_209766_, BuiltinRegistries.f_123865_.m_203561_(p_209767_), false, p_209768_);
    }

    public ConfiguredStructureFeature<C, ? extends StructureFeature<C>> m_209773_(C p_209774_, TagKey<Biome> p_209775_, boolean p_209776_, Map<MobCategory, StructureSpawnOverride> p_209777_) {
        return new ConfiguredStructureFeature(this, p_209774_, BuiltinRegistries.f_123865_.m_203561_(p_209775_), p_209776_, p_209777_);
    }

    public static BlockPos m_204766_(RandomSpreadStructurePlacement p_204767_, ChunkPos p_204768_) {
        return new BlockPos(p_204768_.m_45604_(), 0, p_204768_.m_45605_()).m_141952_(p_204767_.f_204977_());
    }

    public boolean m_197171_(RegistryAccess p_197172_, ChunkGenerator p_197173_, BiomeSource p_197174_, StructureManager p_197175_, long p_197176_, ChunkPos p_197177_, C p_197178_, LevelHeightAccessor p_197179_, Predicate<Holder<Biome>> p_197180_) {
        return this.f_191106_.m_197347_(new PieceGeneratorSupplier.Context(p_197173_, p_197174_, p_197176_, p_197177_, p_197178_, p_197179_, p_197180_, p_197175_, p_197172_)).isPresent();
    }

    public PieceGeneratorSupplier<C> m_209787_() {
        return this.f_191106_;
    }

    public PostPlacementProcessor m_191144_() {
        return this.f_191107_;
    }
}

