/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Queues;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.blaze3d.pipeline.MainTarget;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.DisplayData;
import com.mojang.blaze3d.platform.GlDebug;
import com.mojang.blaze3d.platform.GlUtil;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.platform.WindowEventHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.math.Matrix4f;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.Proxy;
import java.net.SocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.FileUtil;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.Util;
import net.minecraft.client.AmbientOcclusionStatus;
import net.minecraft.client.CameraType;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.ClientTelemetryManager;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Game;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.HotbarManager;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.KeyboardHandler;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.Option;
import net.minecraft.client.Options;
import net.minecraft.client.PeriodicNotificationManager;
import net.minecraft.client.ResourceLoadStateTracker;
import net.minecraft.client.Screenshot;
import net.minecraft.client.Timer;
import net.minecraft.client.User;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.components.toasts.TutorialToast;
import net.minecraft.client.gui.font.FontManager;
import net.minecraft.client.gui.screens.BackupConfirmScreen;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.DatapackLoadFailureScreen;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.InBedChatScreen;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.OutOfMemoryScreen;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.client.gui.screens.advancements.AdvancementsScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.social.PlayerSocialManager;
import net.minecraft.client.gui.screens.social.SocialInteractionsScreen;
import net.minecraft.client.gui.screens.worldselection.EditWorldScreen;
import net.minecraft.client.main.GameConfig;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.multiplayer.ClientHandshakePacketListenerImpl;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.profiling.ClientMetricsSamplersProvider;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.GpuWarnlistManager;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.VirtualScreen;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.ClientPackSource;
import net.minecraft.client.resources.FoliageColorReloadListener;
import net.minecraft.client.resources.GrassColorReloadListener;
import net.minecraft.client.resources.LegacyPackResourcesAdapter;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.client.resources.PackResourcesAdapterV4;
import net.minecraft.client.resources.PaintingTextureManager;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.client.resources.SplashManager;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.language.LanguageManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.searchtree.MutableSearchTree;
import net.minecraft.client.searchtree.ReloadableIdSearchTree;
import net.minecraft.client.searchtree.ReloadableSearchTree;
import net.minecraft.client.searchtree.SearchRegistry;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.tutorial.Tutorial;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.KeybindComponent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.protocol.handshake.ClientIntentionPacket;
import net.minecraft.network.protocol.login.ServerboundHelloPacket;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.Bootstrap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.WorldStem;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.server.level.progress.ProcessorChunkProgressListener;
import net.minecraft.server.level.progress.StoringChunkProgressListener;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.FolderRepositorySource;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FileZipper;
import net.minecraft.util.FrameTimer;
import net.minecraft.util.MemoryReserve;
import net.minecraft.util.ModCheck;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.Unit;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.profiling.ContinuousProfiler;
import net.minecraft.util.profiling.InactiveProfiler;
import net.minecraft.util.profiling.ProfileResults;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.profiling.ResultField;
import net.minecraft.util.profiling.SingleTickProfiler;
import net.minecraft.util.profiling.metrics.MetricsSamplerProvider;
import net.minecraft.util.profiling.metrics.profiling.ActiveMetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.InactiveMetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.MetricsRecorder;
import net.minecraft.util.profiling.metrics.storage.MetricsPersister;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.ChatVisiblity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PlayerHeadItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.RecipeBookRegistry;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.ScreenOpenEvent;
import net.minecraftforge.client.extensions.IForgeMinecraft;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.loading.ClientModLoader;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.gametest.ForgeGameTestHooks;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.io.FileUtils;
import org.lwjgl.util.tinyfd.TinyFileDialogs;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class Minecraft
extends ReentrantBlockableEventLoop<Runnable>
implements WindowEventHandler,
IForgeMinecraft {
    private static Minecraft f_90981_;
    private static final Logger f_90982_;
    public static final boolean f_91002_;
    private static final int f_167843_ = 10;
    public static final ResourceLocation f_91055_;
    public static final ResourceLocation f_91058_;
    public static final ResourceLocation f_91059_;
    private static final ResourceLocation f_205119_;
    private static final CompletableFuture<Unit> f_90983_;
    private static final Component f_90984_;
    public static final String f_167848_ = "Please make sure you have up-to-date drivers (see aka.ms/mcdriver for instructions).";
    private final File f_90985_;
    private final PropertyMap f_90986_;
    public final TextureManager f_90987_;
    private final DataFixer f_90988_;
    private final VirtualScreen f_90989_;
    private final Window f_90990_;
    private final Timer f_90991_ = new Timer(20.0f, 0L);
    private final RenderBuffers f_90993_;
    public final LevelRenderer f_91060_;
    private final EntityRenderDispatcher f_90994_;
    private final ItemRenderer f_90995_;
    private final ItemInHandRenderer f_90996_;
    public final ParticleEngine f_91061_;
    private final SearchRegistry f_90997_ = new SearchRegistry();
    private final User f_90998_;
    public final Font f_91062_;
    public final GameRenderer f_91063_;
    public final DebugRenderer f_91064_;
    private final AtomicReference<StoringChunkProgressListener> f_90999_ = new AtomicReference();
    public final Gui f_91065_;
    public final Options f_91066_;
    private final HotbarManager f_91000_;
    public final MouseHandler f_91067_;
    public final KeyboardHandler f_91068_;
    public final File f_91069_;
    private final String f_91001_;
    private final String f_91029_;
    private final Proxy f_91030_;
    private final LevelStorageSource f_91031_;
    public final FrameTimer f_91070_ = new FrameTimer();
    private final boolean f_91032_;
    private final boolean f_91033_;
    private final boolean f_91034_;
    private final boolean f_91035_;
    private final ReloadableResourceManager f_91036_;
    private final ClientPackSource f_91037_;
    private final PackRepository f_91038_;
    private final LanguageManager f_91039_;
    private final BlockColors f_91040_;
    private final ItemColors f_91041_;
    private final RenderTarget f_91042_;
    private final SoundManager f_91043_;
    private final MusicManager f_91044_;
    private final FontManager f_91045_;
    private final SplashManager f_91046_;
    private final GpuWarnlistManager f_91047_;
    private final PeriodicNotificationManager f_205120_ = new PeriodicNotificationManager(f_205119_, Minecraft::m_210782_);
    private final MinecraftSessionService f_91048_;
    private final UserApiService f_193584_;
    private final SkinManager f_91050_;
    private final ModelManager f_91051_;
    private final BlockRenderDispatcher f_91052_;
    private final PaintingTextureManager f_91053_;
    private final MobEffectTextureManager f_91054_;
    private final ToastComponent f_91003_;
    private final Game f_91004_ = new Game(this);
    private final Tutorial f_91005_;
    private final PlayerSocialManager f_91006_;
    private final EntityModelSet f_167844_;
    private final BlockEntityRenderDispatcher f_167845_;
    private final UUID f_193582_ = UUID.randomUUID();
    @Nullable
    public MultiPlayerGameMode f_91072_;
    @Nullable
    public ClientLevel f_91073_;
    @Nullable
    public LocalPlayer f_91074_;
    @Nullable
    private IntegratedServer f_91007_;
    @Nullable
    private ServerData f_91008_;
    @Nullable
    private Connection f_91009_;
    private boolean f_91010_;
    @Nullable
    public Entity f_91075_;
    @Nullable
    public Entity f_91076_;
    @Nullable
    public HitResult f_91077_;
    private int f_91011_;
    protected int f_91078_;
    private volatile boolean f_91012_;
    private float f_91013_;
    private long f_91014_ = Util.m_137569_();
    private long f_91015_;
    private int f_91016_;
    public boolean f_91079_;
    @Nullable
    public Screen f_91080_;
    @Nullable
    private Overlay f_91081_;
    private boolean f_91017_;
    private Thread f_91018_;
    private volatile boolean f_91019_ = true;
    @Nullable
    private Supplier<CrashReport> f_91020_;
    private static int f_91021_;
    public String f_90977_ = "";
    public boolean f_167842_;
    public boolean f_90978_;
    public boolean f_90979_;
    public boolean f_90980_ = true;
    private boolean f_91022_;
    private final Queue<Runnable> f_91023_ = Queues.newConcurrentLinkedQueue();
    @Nullable
    private CompletableFuture<Void> f_91024_;
    @Nullable
    private TutorialToast f_91025_;
    private ProfilerFiller f_91026_ = InactiveProfiler.f_18554_;
    private int f_91027_;
    private final ContinuousProfiler f_91028_ = new ContinuousProfiler(Util.f_137440_, () -> this.f_91027_);
    @Nullable
    private ProfileResults f_91056_;
    private MetricsRecorder f_167846_ = InactiveMetricsRecorder.f_146153_;
    private final ResourceLoadStateTracker f_167847_ = new ResourceLoadStateTracker();
    private String f_91057_ = "root";

    public Minecraft(GameConfig p_91084_) {
        super("Client");
        int i;
        String s;
        f_90981_ = this;
        this.f_91069_ = p_91084_.f_101907_.f_101916_;
        File file1 = p_91084_.f_101907_.f_101918_;
        this.f_90985_ = p_91084_.f_101907_.f_101917_;
        this.f_91001_ = p_91084_.f_101908_.f_101927_;
        this.f_91029_ = p_91084_.f_101908_.f_101928_;
        this.f_90986_ = p_91084_.f_101905_.f_101944_;
        this.f_91037_ = new ClientPackSource(new File(this.f_91069_, "server-resource-packs"), p_91084_.f_101907_.m_101925_());
        this.f_91038_ = new PackRepository(Minecraft::createClientPackAdapter, new RepositorySource[]{this.f_91037_, new FolderRepositorySource(this.f_90985_, PackSource.f_10527_)});
        this.f_91030_ = p_91084_.f_101905_.f_101945_;
        YggdrasilAuthenticationService yggdrasilauthenticationservice = new YggdrasilAuthenticationService(this.f_91030_);
        this.f_91048_ = yggdrasilauthenticationservice.createMinecraftSessionService();
        this.f_193584_ = this.m_193585_(yggdrasilauthenticationservice, p_91084_);
        this.f_90998_ = p_91084_.f_101905_.f_101942_;
        f_90982_.info("Setting user: {}", (Object)this.f_90998_.m_92546_());
        this.f_91033_ = p_91084_.f_101908_.f_101926_;
        this.f_91034_ = !p_91084_.f_101908_.f_101929_;
        this.f_91035_ = !p_91084_.f_101908_.f_101930_;
        this.f_91032_ = Minecraft.m_91272_();
        this.f_91007_ = null;
        if (this.m_91400_() && p_91084_.f_101909_.f_101937_ != null) {
            s = p_91084_.f_101909_.f_101937_;
            i = p_91084_.f_101909_.f_101938_;
        } else {
            s = null;
            i = 0;
        }
        KeybindComponent.m_130919_(KeyMapping::m_90842_);
        this.f_90988_ = DataFixers.m_14512_();
        this.f_91003_ = new ToastComponent(this);
        this.f_91018_ = Thread.currentThread();
        this.f_91066_ = new Options(this, this.f_91069_);
        this.f_91005_ = new Tutorial(this, this.f_91066_);
        this.f_91000_ = new HotbarManager(this.f_91069_, this.f_90988_);
        f_90982_.info("Backend library: {}", (Object)RenderSystem.m_69517_());
        DisplayData displaydata = this.f_91066_.f_92129_ > 0 && this.f_91066_.f_92128_ > 0 ? new DisplayData(this.f_91066_.f_92128_, this.f_91066_.f_92129_, p_91084_.f_101906_.f_84007_, p_91084_.f_101906_.f_84008_, p_91084_.f_101906_.f_84009_) : p_91084_.f_101906_;
        Util.f_137440_ = RenderSystem.m_69576_();
        if (((Boolean)ForgeConfig.CLIENT.forceSystemNanoTime.get()).booleanValue()) {
            Util.f_137440_ = System::nanoTime;
        }
        this.f_90989_ = new VirtualScreen(this);
        this.f_90990_ = this.f_90989_.m_110872_(displaydata, this.f_91066_.f_92123_, this.m_91270_());
        this.m_7440_(true);
        if (!f_91002_) {
            try {
                InputStream inputstream = this.m_91100_().m_118555_().m_8031_(PackType.CLIENT_RESOURCES, new ResourceLocation("icons/icon_16x16.png"));
                InputStream inputstream1 = this.m_91100_().m_118555_().m_8031_(PackType.CLIENT_RESOURCES, new ResourceLocation("icons/icon_32x32.png"));
                this.f_90990_.m_85395_(inputstream, inputstream1);
            }
            catch (IOException ioexception) {
                f_90982_.error("Couldn't set icon", (Throwable)ioexception);
            }
        }
        this.f_90990_.m_85380_(this.f_91066_.f_92113_);
        this.f_91067_ = new MouseHandler(this);
        this.f_91068_ = new KeyboardHandler(this);
        this.f_91068_.m_90887_(this.f_90990_.m_85439_());
        RenderSystem.m_69580_((int)this.f_91066_.f_92035_, (boolean)false);
        this.f_91042_ = new MainTarget(this.f_90990_.m_85441_(), this.f_90990_.m_85442_());
        this.f_91042_.m_83931_(0.0f, 0.0f, 0.0f, 0.0f);
        this.f_91042_.m_83954_(f_91002_);
        this.f_91036_ = new ReloadableResourceManager(PackType.CLIENT_RESOURCES);
        RecipeBookRegistry.initDefaultValues();
        ClientModLoader.begin((Minecraft)this, (PackRepository)this.f_91038_, (ReloadableResourceManager)this.f_91036_, (ClientPackSource)this.f_91037_);
        this.f_91038_.m_10506_();
        this.f_91066_.m_92145_(this.f_91038_);
        this.f_91039_ = new LanguageManager(this.f_91066_.f_92075_);
        this.f_91036_.m_7217_((PreparableReloadListener)this.f_91039_);
        this.f_90987_ = new TextureManager(this.f_91036_);
        this.f_91036_.m_7217_(this.f_90987_);
        this.f_91050_ = new SkinManager(this.f_90987_, new File(file1, "skins"), this.f_91048_);
        this.f_91031_ = new LevelStorageSource(this.f_91069_.toPath().resolve("saves"), this.f_91069_.toPath().resolve("backups"), this.f_90988_);
        this.f_91043_ = new SoundManager((ResourceManager)this.f_91036_, this.f_91066_);
        this.f_91036_.m_7217_((PreparableReloadListener)this.f_91043_);
        this.f_91046_ = new SplashManager(this.f_90998_);
        this.f_91036_.m_7217_((PreparableReloadListener)this.f_91046_);
        this.f_91044_ = new MusicManager(this);
        this.f_91045_ = new FontManager(this.f_90987_);
        this.f_91062_ = this.f_91045_.m_95006_();
        this.f_91036_.m_7217_(this.f_91045_.m_95015_());
        this.m_91336_(this.m_91390_());
        this.f_91036_.m_7217_((PreparableReloadListener)new GrassColorReloadListener());
        this.f_91036_.m_7217_((PreparableReloadListener)new FoliageColorReloadListener());
        this.f_90990_.m_85403_("Startup");
        RenderSystem.m_69902_((int)0, (int)0, (int)this.f_90990_.m_85441_(), (int)this.f_90990_.m_85442_());
        this.f_90990_.m_85403_("Post startup");
        this.f_91040_ = BlockColors.m_92574_();
        this.f_91041_ = ItemColors.m_92683_(this.f_91040_);
        this.f_91051_ = new ModelManager(this.f_90987_, this.f_91040_, this.f_91066_.f_92027_);
        this.f_91036_.m_7217_((PreparableReloadListener)this.f_91051_);
        this.f_167844_ = new EntityModelSet();
        this.f_91036_.m_7217_((PreparableReloadListener)this.f_167844_);
        this.f_167845_ = new BlockEntityRenderDispatcher(this.f_91062_, this.f_167844_, this::m_91289_);
        this.f_91036_.m_7217_((PreparableReloadListener)this.f_167845_);
        BlockEntityWithoutLevelRenderer blockentitywithoutlevelrenderer = new BlockEntityWithoutLevelRenderer(this.f_167845_, this.f_167844_);
        this.f_91036_.m_7217_((PreparableReloadListener)blockentitywithoutlevelrenderer);
        this.f_90995_ = new ItemRenderer(this.f_90987_, this.f_91051_, this.f_91041_, blockentitywithoutlevelrenderer);
        this.f_90994_ = new EntityRenderDispatcher(this.f_90987_, this.f_90995_, this.f_91062_, this.f_91066_, this.f_167844_);
        this.f_91036_.m_7217_((PreparableReloadListener)this.f_90994_);
        this.f_90996_ = new ItemInHandRenderer(this);
        this.f_91036_.m_7217_((PreparableReloadListener)this.f_90995_);
        this.f_90993_ = new RenderBuffers();
        this.f_91063_ = new GameRenderer(this, this.f_91036_, this.f_90993_);
        this.f_91036_.m_7217_((PreparableReloadListener)this.f_91063_);
        this.f_91006_ = new PlayerSocialManager(this, this.f_193584_);
        this.f_91052_ = new BlockRenderDispatcher(this.f_91051_.m_119430_(), blockentitywithoutlevelrenderer, this.f_91040_);
        this.f_91036_.m_7217_((PreparableReloadListener)this.f_91052_);
        this.f_91060_ = new LevelRenderer(this, this.f_90993_);
        ModLoader.get().postEvent((Event)new RenderLevelStageEvent.RegisterStageEvent());
        this.f_91036_.m_7217_((PreparableReloadListener)this.f_91060_);
        this.m_91271_();
        this.f_91036_.m_7217_((PreparableReloadListener)this.f_90997_);
        this.f_91061_ = new ParticleEngine(this.f_91073_, this.f_90987_);
        ModLoader.get().postEvent((Event)new ParticleFactoryRegisterEvent());
        this.f_91036_.m_7217_(this.f_91061_);
        this.f_91053_ = new PaintingTextureManager(this.f_90987_);
        this.f_91036_.m_7217_((PreparableReloadListener)this.f_91053_);
        this.f_91054_ = new MobEffectTextureManager(this.f_90987_);
        this.f_91036_.m_7217_((PreparableReloadListener)this.f_91054_);
        this.f_91047_ = new GpuWarnlistManager();
        this.f_91036_.m_7217_((PreparableReloadListener)this.f_91047_);
        this.f_91036_.m_7217_((PreparableReloadListener)this.f_205120_);
        this.f_91065_ = new ForgeIngameGui(this);
        this.f_91067_.m_91524_(this.f_90990_.m_85439_());
        this.f_91064_ = new DebugRenderer(this);
        RenderSystem.m_69900_(this::m_91113_);
        if (this.f_91042_.f_83915_ == this.f_90990_.m_85441_() && this.f_91042_.f_83916_ == this.f_90990_.m_85442_()) {
            if (this.f_91066_.f_92052_ && !this.f_90990_.m_85440_()) {
                this.f_90990_.m_85438_();
                this.f_91066_.f_92052_ = this.f_90990_.m_85440_();
            }
        } else {
            StringBuilder stringbuilder = new StringBuilder("Recovering from unsupported resolution (" + this.f_90990_.m_85441_() + "x" + this.f_90990_.m_85442_() + ").\nPlease make sure you have up-to-date drivers (see aka.ms/mcdriver for instructions).");
            if (GlDebug.m_166226_()) {
                stringbuilder.append("\n\nReported GL debug messages:\n").append(String.join((CharSequence)"\n", GlDebug.m_166225_()));
            }
            this.f_90990_.m_166447_(this.f_91042_.f_83915_, this.f_91042_.f_83916_);
            TinyFileDialogs.tinyfd_messageBox((CharSequence)"Minecraft", (CharSequence)stringbuilder.toString(), (CharSequence)"ok", (CharSequence)"error", (boolean)false);
        }
        ForgeGameTestHooks.registerGametests();
        ModLoader.get().postEvent((Event)new RegisterClientReloadListenersEvent(this.f_91036_));
        ModLoader.get().postEvent((Event)new EntityRenderersEvent.RegisterLayerDefinitions());
        ModLoader.get().postEvent((Event)new EntityRenderersEvent.RegisterRenderers());
        this.f_90990_.m_85409_(this.f_91066_.f_92041_);
        this.f_90990_.m_85424_(this.f_91066_.f_92034_);
        this.f_90990_.m_85426_();
        this.m_5741_();
        this.f_91063_.m_172722_(this.m_91100_().m_118555_());
        LoadingOverlay.m_96189_(this);
        List<PackResources> list = this.f_91038_.m_10525_();
        this.f_167847_.m_168557_(ResourceLoadStateTracker.ReloadReason.INITIAL, list);
        this.m_91150_(new LoadingOverlay(this, this.f_91036_.m_142463_(Util.m_183991_(), (Executor)((Object)this), f_90983_, list), p_210745_ -> Util.m_137521_(p_210745_, this::m_91239_, () -> {
            if (SharedConstants.f_136183_) {
                this.m_91273_();
            }
            this.f_167847_.m_168556_();
            if (ClientModLoader.completeModLoading()) {
                return;
            }
            if (s != null) {
                ConnectScreen.m_169267_(new TitleScreen(), this, new ServerAddress(s, i), null);
            } else {
                this.m_91152_(new TitleScreen(true));
            }
        }), false));
    }

    private static boolean m_210782_(Object p_210783_) {
        try {
            return Locale.getDefault().getISO3Country().equals(p_210783_);
        }
        catch (MissingResourceException missingresourceexception) {
            return false;
        }
    }

    public void m_91341_() {
        this.f_90990_.m_85422_(this.m_91270_());
    }

    private String m_91270_() {
        StringBuilder stringbuilder = new StringBuilder("Minecraft");
        if (Minecraft.m_193589_().m_184597_()) {
            stringbuilder.append("*");
        }
        stringbuilder.append(" ");
        stringbuilder.append(SharedConstants.m_183709_().getName());
        ClientPacketListener clientpacketlistener = this.m_91403_();
        if (clientpacketlistener != null && clientpacketlistener.m_6198_().m_129536_()) {
            stringbuilder.append(" - ");
            if (this.f_91007_ != null && !this.f_91007_.m_6992_()) {
                stringbuilder.append(I18n.m_118938_("title.singleplayer", new Object[0]));
            } else if (this.m_91294_()) {
                stringbuilder.append(I18n.m_118938_("title.multiplayer.realms", new Object[0]));
            } else if (!(this.f_91007_ != null || this.f_91008_ != null && this.f_91008_.m_105389_())) {
                stringbuilder.append(I18n.m_118938_("title.multiplayer.other", new Object[0]));
            } else {
                stringbuilder.append(I18n.m_118938_("title.multiplayer.lan", new Object[0]));
            }
        }
        return stringbuilder.toString();
    }

    private UserApiService m_193585_(YggdrasilAuthenticationService p_193586_, GameConfig p_193587_) {
        try {
            if ("0".equals(p_193587_.f_101905_.f_101942_.m_92547_())) {
                return UserApiService.OFFLINE;
            }
            return p_193586_.createUserApiService(p_193587_.f_101905_.f_101942_.m_92547_());
        }
        catch (AuthenticationException authenticationexception) {
            f_90982_.error("Failed to verify authentication", (Throwable)authenticationexception);
            return UserApiService.OFFLINE;
        }
    }

    public static ModCheck m_193589_() {
        return ModCheck.m_184600_((String)"vanilla", ClientBrandRetriever::m_129629_, (String)"Client", Minecraft.class);
    }

    private void m_91239_(Throwable p_91240_) {
        if (this.f_91038_.m_10524_().stream().anyMatch(e -> !e.m_10449_())) {
            this.m_91241_(p_91240_, null);
        } else {
            Util.m_137559_(p_91240_);
        }
    }

    public void m_91241_(Throwable p_91242_, @Nullable Component p_91243_) {
        f_90982_.info("Caught error loading resourcepacks, removing all selected resourcepacks", p_91242_);
        this.f_167847_.m_168560_(p_91242_);
        this.f_91038_.m_10509_(Collections.emptyList());
        this.f_91066_.f_92117_.clear();
        this.f_91066_.f_92118_.clear();
        this.f_91066_.m_92169_();
        this.m_168019_(true).thenRun(() -> {
            ToastComponent toastcomponent = this.m_91300_();
            SystemToast.m_94869_((ToastComponent)toastcomponent, (SystemToast.SystemToastIds)SystemToast.SystemToastIds.PACK_LOAD_FAILURE, (Component)new TranslatableComponent("resourcePack.load_fail"), (Component)p_91243_);
        });
    }

    public void m_91374_() {
        this.f_91018_ = Thread.currentThread();
        if (Runtime.getRuntime().availableProcessors() > 4) {
            this.f_91018_.setPriority(10);
        }
        try {
            boolean flag = false;
            while (this.f_91019_) {
                if (this.f_91020_ != null) {
                    Minecraft.m_91332_(this.f_91020_.get());
                    return;
                }
                try {
                    SingleTickProfiler singletickprofiler = SingleTickProfiler.m_18632_((String)"Renderer");
                    boolean flag1 = this.m_91274_();
                    this.f_91026_ = this.m_167970_(flag1, singletickprofiler);
                    this.f_91026_.m_7242_();
                    this.f_167846_.m_142759_();
                    this.m_91383_(!flag);
                    this.f_167846_.m_142758_();
                    this.f_91026_.m_7241_();
                    this.m_91338_(flag1, singletickprofiler);
                }
                catch (OutOfMemoryError outofmemoryerror) {
                    if (flag) {
                        throw outofmemoryerror;
                    }
                    this.m_91394_();
                    this.m_91152_((Screen)new OutOfMemoryScreen());
                    System.gc();
                    f_90982_.error(LogUtils.FATAL_MARKER, "Out of memory", (Throwable)outofmemoryerror);
                    flag = true;
                }
            }
        }
        catch (ReportedException reportedexception) {
            this.m_91354_(reportedexception.m_134761_());
            this.m_91394_();
            f_90982_.error(LogUtils.FATAL_MARKER, "Reported exception thrown!", (Throwable)reportedexception);
            Minecraft.m_91332_(reportedexception.m_134761_());
        }
        catch (Throwable throwable) {
            CrashReport crashreport = this.m_91354_(new CrashReport("Unexpected error", throwable));
            f_90982_.error(LogUtils.FATAL_MARKER, "Unreported exception thrown!", throwable);
            this.m_91394_();
            Minecraft.m_91332_(crashreport);
        }
    }

    void m_91336_(boolean p_91337_) {
        this.f_91045_.m_95011_((Map)(p_91337_ ? ImmutableMap.of((Object)f_91055_, (Object)f_91058_) : ImmutableMap.of()));
    }

    public void m_91271_() {
        ReloadableSearchTree reloadablesearchtree = new ReloadableSearchTree(p_91317_ -> p_91317_.m_41651_(null, (TooltipFlag)TooltipFlag.Default.NORMAL).stream().map(p_210807_ -> ChatFormatting.m_126649_((String)p_210807_.getString()).trim()).filter(p_210809_ -> !p_210809_.isEmpty()), p_91121_ -> Stream.of(Registry.f_122827_.m_7981_((Object)p_91121_.m_41720_())));
        ReloadableIdSearchTree reloadableidsearchtree = new ReloadableIdSearchTree(p_91121_ -> p_91121_.m_204131_().map(TagKey::f_203868_));
        NonNullList nonnulllist = NonNullList.m_122779_();
        for (Item item : Registry.f_122827_) {
            item.m_6787_(CreativeModeTab.f_40754_, (NonNullList<ItemStack>)nonnulllist);
        }
        nonnulllist.forEach(p_210707_ -> {
            reloadablesearchtree.m_8080_((Object)p_210707_);
            reloadableidsearchtree.m_8080_((Object)p_210707_);
        });
        ReloadableSearchTree reloadablesearchtree1 = new ReloadableSearchTree(p_210778_ -> p_210778_.m_100516_().stream().flatMap(p_210776_ -> p_210776_.m_8043_().m_41651_(null, (TooltipFlag)TooltipFlag.Default.NORMAL).stream()).map(p_210803_ -> ChatFormatting.m_126649_((String)p_210803_.getString()).trim()).filter(p_210805_ -> !p_210805_.isEmpty()), p_210701_ -> p_210701_.m_100516_().stream().map(p_210681_ -> Registry.f_122827_.m_7981_((Object)p_210681_.m_8043_().m_41720_())));
        this.f_90997_.m_119951_(SearchRegistry.f_119941_, (MutableSearchTree)reloadablesearchtree);
        this.f_90997_.m_119951_(SearchRegistry.f_119942_, (MutableSearchTree)reloadableidsearchtree);
        this.f_90997_.m_119951_(SearchRegistry.f_119943_, (MutableSearchTree)reloadablesearchtree1);
    }

    private void m_91113_(int p_91114_, long p_91115_) {
        this.f_91066_.f_92041_ = false;
        this.f_91066_.m_92169_();
    }

    private static boolean m_91272_() {
        String[] astring;
        for (String s : astring = new String[]{"sun.arch.data.model", "com.ibm.vm.bitmode", "os.arch"}) {
            String s1 = System.getProperty(s);
            if (s1 == null || !s1.contains("64")) continue;
            return true;
        }
        return false;
    }

    public RenderTarget m_91385_() {
        return this.f_91042_;
    }

    public String m_91388_() {
        return this.f_91001_;
    }

    public String m_91389_() {
        return this.f_91029_;
    }

    public void m_199935_(Supplier<CrashReport> p_199936_) {
        this.f_91020_ = p_199936_;
    }

    public static void m_91332_(CrashReport p_91333_) {
        File file1 = new File(Minecraft.m_91087_().f_91069_, "crash-reports");
        File file2 = new File(file1, "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-client.txt");
        Bootstrap.m_135875_(p_91333_.m_127526_());
        if (p_91333_.m_127527_() != null) {
            Bootstrap.m_135875_("#@!@# Game crashed! Crash report saved to: #@!@# " + String.valueOf(p_91333_.m_127527_()));
            ServerLifecycleHooks.handleExit((int)-1);
        } else if (p_91333_.m_127512_(file2)) {
            Bootstrap.m_135875_("#@!@# Game crashed! Crash report saved to: #@!@# " + file2.getAbsolutePath());
            ServerLifecycleHooks.handleExit((int)-1);
        } else {
            Bootstrap.m_135875_("#@?@# Game crashed! Crash report could not be saved. #@?@#");
            ServerLifecycleHooks.handleExit((int)-2);
        }
    }

    public boolean m_91390_() {
        return this.f_91066_.f_92043_;
    }

    public CompletableFuture<Void> m_91391_() {
        return this.m_168019_(false);
    }

    private CompletableFuture<Void> m_168019_(boolean p_168020_) {
        if (this.f_91024_ != null) {
            return this.f_91024_;
        }
        CompletableFuture<Void> completablefuture = new CompletableFuture<Void>();
        if (!p_168020_ && this.f_91081_ instanceof LoadingOverlay) {
            this.f_91024_ = completablefuture;
            return completablefuture;
        }
        this.f_91038_.m_10506_();
        List<PackResources> list = this.f_91038_.m_10525_();
        if (!p_168020_) {
            this.f_167847_.m_168557_(ResourceLoadStateTracker.ReloadReason.MANUAL, list);
        }
        this.m_91150_(new LoadingOverlay(this, this.f_91036_.m_142463_(Util.m_183991_(), (Executor)((Object)this), f_90983_, list), p_210750_ -> Util.m_137521_(p_210750_, this::m_91239_, () -> {
            this.f_91060_.m_109818_();
            this.f_167847_.m_168556_();
            completablefuture.complete(null);
        }), true));
        return completablefuture;
    }

    private void m_91273_() {
        boolean flag = false;
        BlockModelShaper blockmodelshaper = this.m_91289_().m_110907_();
        BakedModel bakedmodel = blockmodelshaper.m_110881_().m_119409_();
        for (Object block : Registry.f_122824_) {
            for (BlockState blockstate : ((Block)((Object)block)).m_49965_().m_61056_()) {
                BakedModel bakedmodel1;
                if (blockstate.m_60799_() != RenderShape.MODEL || (bakedmodel1 = blockmodelshaper.m_110893_(blockstate)) != bakedmodel) continue;
                f_90982_.debug("Missing model for: {}", (Object)blockstate);
                flag = true;
            }
        }
        TextureAtlasSprite textureatlassprite1 = bakedmodel.m_6160_();
        for (Block block1 : Registry.f_122824_) {
            for (BlockState blockstate1 : block1.m_49965_().m_61056_()) {
                TextureAtlasSprite textureatlassprite = blockmodelshaper.m_110882_(blockstate1);
                if (blockstate1.m_60795_() || textureatlassprite != textureatlassprite1) continue;
                f_90982_.debug("Missing particle icon for: {}", (Object)blockstate1);
                flag = true;
            }
        }
        NonNullList nonnulllist = NonNullList.m_122779_();
        for (Item item : Registry.f_122827_) {
            nonnulllist.clear();
            item.m_6787_(CreativeModeTab.f_40754_, (NonNullList<ItemStack>)nonnulllist);
            for (ItemStack itemstack : nonnulllist) {
                String s = itemstack.m_41778_();
                String s1 = new TranslatableComponent(s).getString();
                if (!s1.toLowerCase(Locale.ROOT).equals(item.m_5524_())) continue;
                f_90982_.debug("Missing translation for: {} {} {}", new Object[]{itemstack, s, itemstack.m_41720_()});
            }
        }
        flag |= MenuScreens.m_96198_();
        if (flag |= EntityRenderers.m_174035_()) {
            throw new IllegalStateException("Your game data is foobar, fix the errors above!");
        }
    }

    public LevelStorageSource m_91392_() {
        return this.f_91031_;
    }

    private void m_91326_(String p_91327_) {
        ChatStatus minecraft$chatstatus = this.m_168022_();
        if (!minecraft$chatstatus.m_142594_(this.m_91090_())) {
            this.f_91065_.m_93063_(minecraft$chatstatus.m_168034_(), false);
        } else {
            this.m_91152_((Screen)new ChatScreen(p_91327_));
        }
    }

    public void m_91152_(@Nullable Screen p_91153_) {
        if (SharedConstants.f_136183_ && Thread.currentThread() != this.f_91018_) {
            f_90982_.error("setScreen called from non-game thread");
        }
        if (p_91153_ == null && this.f_91073_ == null) {
            p_91153_ = new TitleScreen();
        } else if (p_91153_ == null && this.f_91074_.m_21224_()) {
            if (this.f_91074_.m_108632_()) {
                p_91153_ = new DeathScreen(null, this.f_91073_.m_6106_().m_5466_());
            } else {
                this.f_91074_.m_7583_();
            }
        }
        ForgeHooksClient.clearGuiLayers((Minecraft)this);
        Screen old = this.f_91080_;
        ScreenOpenEvent event = new ScreenOpenEvent(p_91153_);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        p_91153_ = event.getScreen();
        if (old != null && p_91153_ != old) {
            old.m_7861_();
        }
        this.f_91080_ = p_91153_;
        BufferUploader.m_166835_();
        if (p_91153_ != null) {
            this.f_91067_.m_91602_();
            KeyMapping.m_90847_();
            p_91153_.m_6575_(this, this.f_90990_.m_85445_(), this.f_90990_.m_85446_());
            this.f_91079_ = false;
        } else {
            this.f_91043_.m_120407_();
            this.f_91067_.m_91601_();
        }
        this.m_91341_();
    }

    public void m_91150_(@Nullable Overlay p_91151_) {
        this.f_91081_ = p_91151_;
    }

    public void m_91393_() {
        try {
            f_90982_.info("Stopping!");
            try {
                NarratorChatListener.f_93311_.m_93329_();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (this.f_91073_ != null) {
                    this.f_91073_.m_7462_();
                }
                this.m_91399_();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.f_91080_ != null) {
                this.f_91080_.m_7861_();
            }
            this.close();
        }
        finally {
            Util.f_137440_ = System::nanoTime;
            if (this.f_91020_ == null) {
                System.exit(0);
            }
        }
    }

    public void close() {
        try {
            this.f_205120_.close();
            this.f_91051_.close();
            this.f_91045_.close();
            this.f_91063_.close();
            this.f_91060_.close();
            this.f_91043_.m_120406_();
            this.f_91038_.close();
            this.f_91061_.m_107301_();
            this.f_91054_.close();
            this.f_91053_.close();
            this.f_90987_.close();
            this.f_91036_.close();
            Util.m_137580_();
        }
        catch (Throwable throwable) {
            f_90982_.error("Shutdown failure!", throwable);
            throw throwable;
        }
        finally {
            this.f_90989_.close();
            this.f_90990_.close();
        }
    }

    private void m_91383_(boolean p_91384_) {
        boolean flag;
        Runnable runnable;
        this.f_90990_.m_85403_("Pre render");
        long i = Util.m_137569_();
        if (this.f_90990_.m_85411_()) {
            this.m_91395_();
        }
        if (this.f_91024_ != null && !(this.f_91081_ instanceof LoadingOverlay)) {
            CompletableFuture<Void> completablefuture = this.f_91024_;
            this.f_91024_ = null;
            this.m_91391_().thenRun(() -> completablefuture.complete(null));
        }
        while ((runnable = this.f_91023_.poll()) != null) {
            runnable.run();
        }
        if (p_91384_) {
            int j = this.f_90991_.m_92525_(Util.m_137550_());
            this.f_91026_.m_6180_("scheduledExecutables");
            this.m_18699_();
            this.f_91026_.m_7238_();
            this.f_91026_.m_6180_("tick");
            for (int k = 0; k < Math.min(10, j); ++k) {
                this.f_91026_.m_6174_("clientTick");
                this.m_91398_();
            }
            this.f_91026_.m_7238_();
        }
        this.f_91067_.m_91523_();
        this.f_90990_.m_85403_("Render");
        this.f_91026_.m_6180_("sound");
        this.f_91043_.m_120361_(this.f_91063_.m_109153_());
        this.f_91026_.m_7238_();
        this.f_91026_.m_6180_("render");
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        RenderSystem.m_157182_();
        RenderSystem.m_69421_((int)16640, (boolean)f_91002_);
        this.f_91042_.m_83947_(true);
        FogRenderer.m_109017_();
        this.f_91026_.m_6180_("display");
        RenderSystem.m_69493_();
        RenderSystem.m_69481_();
        this.f_91026_.m_7238_();
        if (!this.f_91079_) {
            ForgeEventFactory.onRenderTickStart((float)(this.f_91012_ ? this.f_91013_ : this.f_90991_.f_92518_));
            this.f_91026_.m_6182_("gameRenderer");
            this.f_91063_.m_109093_(this.f_91012_ ? this.f_91013_ : this.f_90991_.f_92518_, i, p_91384_);
            this.f_91026_.m_6182_("toasts");
            this.f_91003_.m_94920_(new PoseStack());
            this.f_91026_.m_7238_();
            ForgeEventFactory.onRenderTickEnd((float)(this.f_91012_ ? this.f_91013_ : this.f_90991_.f_92518_));
        }
        if (this.f_91056_ != null) {
            this.f_91026_.m_6180_("fpsPie");
            this.m_91140_(new PoseStack(), this.f_91056_);
            this.f_91026_.m_7238_();
        }
        this.f_91026_.m_6180_("blit");
        this.f_91042_.m_83970_();
        posestack.m_85849_();
        posestack.m_85836_();
        RenderSystem.m_157182_();
        this.f_91042_.m_83938_(this.f_90990_.m_85441_(), this.f_90990_.m_85442_());
        posestack.m_85849_();
        RenderSystem.m_157182_();
        this.f_91026_.m_6182_("updateDisplay");
        this.f_90990_.m_85435_();
        int i1 = this.m_91275_();
        if ((double)i1 < Option.f_91670_.m_92235_()) {
            RenderSystem.m_69830_((int)i1);
        }
        this.f_91026_.m_6182_("yield");
        Thread.yield();
        this.f_91026_.m_7238_();
        this.f_90990_.m_85403_("Post render");
        ++this.f_91016_;
        boolean bl = flag = this.m_91091_() && (this.f_91080_ != null && this.f_91080_.m_7043_() || this.f_91081_ != null && this.f_91081_.m_7859_()) && !this.f_91007_.m_6992_();
        if (this.f_91012_ != flag) {
            if (this.f_91012_) {
                this.f_91013_ = this.f_90991_.f_92518_;
            } else {
                this.f_90991_.f_92518_ = this.f_91013_;
            }
            this.f_91012_ = flag;
        }
        long l = Util.m_137569_();
        this.f_91070_.m_13755_(l - this.f_91014_);
        this.f_91014_ = l;
        this.f_91026_.m_6180_("fpsUpdate");
        while (Util.m_137550_() >= this.f_91015_ + 1000L) {
            f_91021_ = this.f_91016_;
            this.f_90977_ = String.format("%d fps T: %s%s%s%s B: %d", f_91021_, (double)this.f_91066_.f_92113_ == Option.f_91670_.m_92235_() ? "inf" : Integer.valueOf(this.f_91066_.f_92113_), this.f_91066_.f_92041_ ? " vsync" : "", this.f_91066_.f_92115_, this.f_91066_.f_92114_ == CloudStatus.OFF ? "" : (this.f_91066_.f_92114_ == CloudStatus.FAST ? " fast-clouds" : " fancy-clouds"), this.f_91066_.f_92032_);
            this.f_91015_ += 1000L;
            this.f_91016_ = 0;
        }
        this.f_91026_.m_7238_();
    }

    private boolean m_91274_() {
        return this.f_91066_.f_92063_ && this.f_91066_.f_92064_ && !this.f_91066_.f_92062_;
    }

    private ProfilerFiller m_167970_(boolean p_167971_, @Nullable SingleTickProfiler p_167972_) {
        InactiveProfiler profilerfiller;
        if (!p_167971_) {
            this.f_91028_.m_18437_();
            if (!this.f_167846_.m_142763_() && p_167972_ == null) {
                return InactiveProfiler.f_18554_;
            }
        }
        if (p_167971_) {
            if (!this.f_91028_.m_18436_()) {
                this.f_91027_ = 0;
                this.f_91028_.m_18438_();
            }
            ++this.f_91027_;
            profilerfiller = this.f_91028_.m_18439_();
        } else {
            profilerfiller = InactiveProfiler.f_18554_;
        }
        if (this.f_167846_.m_142763_()) {
            profilerfiller = ProfilerFiller.m_18578_((ProfilerFiller)profilerfiller, (ProfilerFiller)this.f_167846_.m_142610_());
        }
        return SingleTickProfiler.m_18629_((ProfilerFiller)profilerfiller, (SingleTickProfiler)p_167972_);
    }

    private void m_91338_(boolean p_91339_, @Nullable SingleTickProfiler p_91340_) {
        if (p_91340_ != null) {
            p_91340_.m_18634_();
        }
        this.f_91056_ = p_91339_ ? this.f_91028_.m_18440_() : null;
        this.f_91026_ = this.f_91028_.m_18439_();
    }

    public void m_5741_() {
        int i = this.f_90990_.m_85385_(this.f_91066_.f_92072_, this.m_91390_());
        this.f_90990_.m_85378_(i);
        if (this.f_91080_ != null) {
            this.f_91080_.m_6574_(this, this.f_90990_.m_85445_(), this.f_90990_.m_85446_());
            ForgeHooksClient.resizeGuiLayers((Minecraft)this, (int)this.f_90990_.m_85445_(), (int)this.f_90990_.m_85446_());
        }
        RenderTarget rendertarget = this.m_91385_();
        rendertarget.m_83941_(this.f_90990_.m_85441_(), this.f_90990_.m_85442_(), f_91002_);
        if (this.f_91063_ != null) {
            this.f_91063_.m_109097_(this.f_90990_.m_85441_(), this.f_90990_.m_85442_());
        }
        this.f_91067_.m_91599_();
    }

    public void m_5740_() {
        this.f_91067_.m_91603_();
    }

    private int m_91275_() {
        return this.f_91073_ != null || this.f_91080_ == null && this.f_91081_ == null ? this.f_90990_.m_85434_() : 60;
    }

    public void m_91394_() {
        try {
            MemoryReserve.m_182328_();
            this.f_91060_.m_109824_();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.gc();
            if (this.f_91010_ && this.f_91007_ != null) {
                this.f_91007_.m_7570_(true);
            }
            this.m_91320_((Screen)new GenericDirtMessageScreen((Component)new TranslatableComponent("menu.savingLevel")));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.gc();
    }

    public boolean m_167946_(Consumer<TranslatableComponent> p_167947_) {
        Consumer<Path> consumer3;
        if (this.f_167846_.m_142763_()) {
            this.m_167975_();
            return false;
        }
        Consumer<ProfileResults> consumer = p_210788_ -> {
            int i = p_210788_.m_7315_();
            double d0 = (double)p_210788_.m_18577_() / (double)TimeUtil.f_145016_;
            this.execute(() -> p_167947_.accept(new TranslatableComponent("commands.debug.stopped", String.format(Locale.ROOT, "%.2f", d0), i, String.format(Locale.ROOT, "%.2f", (double)i / d0))));
        };
        Consumer<Path> consumer1 = p_210791_ -> {
            MutableComponent component = new TextComponent(p_210791_.toString()).m_130940_(ChatFormatting.UNDERLINE).m_130938_(p_210743_ -> p_210743_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, p_210791_.toFile().getParent())));
            this.execute(() -> Minecraft.lambda$debugClientMetricsStart$23(p_167947_, (Component)component));
        };
        SystemReport systemreport = Minecraft.m_167850_(new SystemReport(), this, this.f_91039_, this.f_91001_, this.f_91066_);
        Consumer<List> consumer2 = p_210677_ -> {
            Path path = this.m_167856_(systemreport, (List<Path>)p_210677_);
            consumer1.accept(path);
        };
        if (this.f_91007_ == null) {
            consumer3 = p_210760_ -> consumer2.accept((List)ImmutableList.of((Object)p_210760_));
        } else {
            this.f_91007_.m_177935_(systemreport);
            CompletableFuture completablefuture = new CompletableFuture();
            CompletableFuture completablefuture1 = new CompletableFuture();
            CompletableFuture.allOf(completablefuture, completablefuture1).thenRunAsync(() -> consumer2.accept((List)ImmutableList.of((Object)((Path)completablefuture.join()), (Object)((Path)completablefuture1.join()))), Util.m_183992_());
            this.f_91007_.m_177923_(p_210679_ -> {}, completablefuture1::complete);
            consumer3 = completablefuture::complete;
        }
        this.f_167846_ = ActiveMetricsRecorder.m_146132_((MetricsSamplerProvider)new ClientMetricsSamplersProvider(Util.f_137440_, this.f_91060_), (LongSupplier)Util.f_137440_, (Executor)Util.m_183992_(), (MetricsPersister)new MetricsPersister("client"), p_210757_ -> {
            this.f_167846_ = InactiveMetricsRecorder.f_146153_;
            consumer.accept((ProfileResults)p_210757_);
        }, consumer3);
        return true;
    }

    private void m_167975_() {
        this.f_167846_.m_142760_();
        if (this.f_91007_ != null) {
            this.f_91007_.m_177929_();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path m_167856_(SystemReport p_167857_, List<Path> p_167858_) {
        Path path;
        String s = this.m_91090_() ? this.m_91092_().m_129910_().m_5462_() : this.m_91089_().f_105362_;
        try {
            String s1 = String.format("%s-%s-%s", new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()), s, SharedConstants.m_183709_().getId());
            String s2 = FileUtil.m_133730_((Path)MetricsPersister.f_146209_, (String)s1, (String)".zip");
            path = MetricsPersister.f_146209_.resolve(s2);
        }
        catch (IOException ioexception1) {
            throw new UncheckedIOException(ioexception1);
        }
        try (FileZipper filezipper = new FileZipper(path);){
            filezipper.m_144703_(Paths.get("system.txt", new String[0]), p_167857_.m_143515_());
            filezipper.m_144703_(Paths.get("client", new String[0]).resolve(this.f_91066_.m_168450_().getName()), this.f_91066_.m_168451_());
            p_167858_.forEach(arg_0 -> ((FileZipper)filezipper).m_144698_(arg_0));
        }
        finally {
            for (Path path1 : p_167858_) {
                try {
                    FileUtils.forceDelete((File)path1.toFile());
                }
                catch (IOException ioexception) {
                    f_90982_.warn("Failed to delete temporary profiling result {}", (Object)path1, (Object)ioexception);
                }
            }
        }
        return path;
    }

    public void m_91111_(int p_91112_) {
        List list;
        if (this.f_91056_ != null && !(list = this.f_91056_.m_6412_(this.f_91057_)).isEmpty()) {
            ResultField resultfield = (ResultField)list.remove(0);
            if (p_91112_ == 0) {
                int i;
                if (!resultfield.f_18610_.isEmpty() && (i = this.f_91057_.lastIndexOf(30)) >= 0) {
                    this.f_91057_ = this.f_91057_.substring(0, i);
                }
            } else if (--p_91112_ < list.size() && !"unspecified".equals(((ResultField)list.get((int)p_91112_)).f_18610_)) {
                if (!this.f_91057_.isEmpty()) {
                    this.f_91057_ = this.f_91057_ + "\u001e";
                }
                this.f_91057_ = this.f_91057_ + ((ResultField)list.get((int)p_91112_)).f_18610_;
            }
        }
    }

    private void m_91140_(PoseStack p_91141_, ProfileResults p_91142_) {
        List list = p_91142_.m_6412_(this.f_91057_);
        ResultField resultfield = (ResultField)list.remove(0);
        RenderSystem.m_69421_((int)256, (boolean)f_91002_);
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Matrix4f matrix4f = Matrix4f.m_162203_(0.0f, this.f_90990_.m_85441_(), 0.0f, this.f_90990_.m_85442_(), 1000.0f, 3000.0f);
        RenderSystem.m_157425_((Matrix4f)matrix4f);
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_166856_();
        posestack.m_85837_(0.0, 0.0, -2000.0);
        RenderSystem.m_157182_();
        RenderSystem.m_69832_((float)1.0f);
        RenderSystem.m_69472_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        int i = 160;
        int j = this.f_90990_.m_85441_() - 160 - 10;
        int k = this.f_90990_.m_85442_() - 320;
        RenderSystem.m_69478_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_5483_((float)j - 176.0f, (float)k - 96.0f - 16.0f, 0.0).m_6122_(200, 0, 0, 0).m_5752_();
        bufferbuilder.m_5483_((float)j - 176.0f, k + 320, 0.0).m_6122_(200, 0, 0, 0).m_5752_();
        bufferbuilder.m_5483_((float)j + 176.0f, k + 320, 0.0).m_6122_(200, 0, 0, 0).m_5752_();
        bufferbuilder.m_5483_((float)j + 176.0f, (float)k - 96.0f - 16.0f, 0.0).m_6122_(200, 0, 0, 0).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69461_();
        double d0 = 0.0;
        for (ResultField resultfield1 : list) {
            int l = Mth.m_14107_((double)(resultfield1.f_18607_ / 4.0)) + 1;
            bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
            int i1 = resultfield1.m_18616_();
            int j1 = i1 >> 16 & 0xFF;
            int k1 = i1 >> 8 & 0xFF;
            int l1 = i1 & 0xFF;
            bufferbuilder.m_5483_(j, k, 0.0).m_6122_(j1, k1, l1, 255).m_5752_();
            for (int i2 = l; i2 >= 0; --i2) {
                float f = (float)((d0 + resultfield1.f_18607_ * (double)i2 / (double)l) * 6.2831854820251465 / 100.0);
                float f1 = Mth.m_14031_((float)f) * 160.0f;
                float f2 = Mth.m_14089_((float)f) * 160.0f * 0.5f;
                bufferbuilder.m_5483_((float)j + f1, (float)k - f2, 0.0).m_6122_(j1, k1, l1, 255).m_5752_();
            }
            tesselator.m_85914_();
            bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
            for (int l2 = l; l2 >= 0; --l2) {
                float f3 = (float)((d0 + resultfield1.f_18607_ * (double)l2 / (double)l) * 6.2831854820251465 / 100.0);
                float f4 = Mth.m_14031_((float)f3) * 160.0f;
                float f5 = Mth.m_14089_((float)f3) * 160.0f * 0.5f;
                if (f5 > 0.0f) continue;
                bufferbuilder.m_5483_((float)j + f4, (float)k - f5, 0.0).m_6122_(j1 >> 1, k1 >> 1, l1 >> 1, 255).m_5752_();
                bufferbuilder.m_5483_((float)j + f4, (float)k - f5 + 10.0f, 0.0).m_6122_(j1 >> 1, k1 >> 1, l1 >> 1, 255).m_5752_();
            }
            tesselator.m_85914_();
            d0 += resultfield1.f_18607_;
        }
        DecimalFormat decimalformat = new DecimalFormat("##0.00");
        decimalformat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT));
        RenderSystem.m_69493_();
        String s = ProfileResults.m_18575_((String)resultfield.f_18610_);
        Object s1 = "";
        if (!"unspecified".equals(s)) {
            s1 = (String)s1 + "[0] ";
        }
        s1 = s.isEmpty() ? (String)s1 + "ROOT " : (String)s1 + s + " ";
        int k2 = 0xFFFFFF;
        this.f_91062_.m_92750_(p_91141_, (String)s1, (float)(j - 160), (float)(k - 80 - 16), 0xFFFFFF);
        s1 = decimalformat.format(resultfield.f_18608_) + "%";
        this.f_91062_.m_92750_(p_91141_, (String)s1, (float)(j + 160 - this.f_91062_.m_92895_((String)s1)), (float)(k - 80 - 16), 0xFFFFFF);
        for (int j2 = 0; j2 < list.size(); ++j2) {
            ResultField resultfield2 = (ResultField)list.get(j2);
            StringBuilder stringbuilder = new StringBuilder();
            if ("unspecified".equals(resultfield2.f_18610_)) {
                stringbuilder.append("[?] ");
            } else {
                stringbuilder.append("[").append(j2 + 1).append("] ");
            }
            Object s2 = stringbuilder.append(resultfield2.f_18610_).toString();
            this.f_91062_.m_92750_(p_91141_, (String)s2, (float)(j - 160), (float)(k + 80 + j2 * 8 + 20), resultfield2.m_18616_());
            s2 = decimalformat.format(resultfield2.f_18607_) + "%";
            this.f_91062_.m_92750_(p_91141_, (String)s2, (float)(j + 160 - 50 - this.f_91062_.m_92895_((String)s2)), (float)(k + 80 + j2 * 8 + 20), resultfield2.m_18616_());
            s2 = decimalformat.format(resultfield2.f_18608_) + "%";
            this.f_91062_.m_92750_(p_91141_, (String)s2, (float)(j + 160 - this.f_91062_.m_92895_((String)s2)), (float)(k + 80 + j2 * 8 + 20), resultfield2.m_18616_());
        }
    }

    public void m_91395_() {
        this.f_91019_ = false;
    }

    public boolean m_91396_() {
        return this.f_91019_;
    }

    public void m_91358_(boolean p_91359_) {
        if (this.f_91080_ == null) {
            boolean flag;
            boolean bl = flag = this.m_91091_() && !this.f_91007_.m_6992_();
            if (flag) {
                this.m_91152_((Screen)new PauseScreen(!p_91359_));
                this.f_91043_.m_120391_();
            } else {
                this.m_91152_((Screen)new PauseScreen(true));
            }
        }
    }

    private void m_91386_(boolean p_91387_) {
        if (!p_91387_) {
            this.f_91078_ = 0;
        }
        if (this.f_91078_ <= 0 && !this.f_91074_.m_6117_()) {
            if (p_91387_ && this.f_91077_ != null && this.f_91077_.m_6662_() == HitResult.Type.BLOCK) {
                BlockHitResult blockhitresult = (BlockHitResult)this.f_91077_;
                BlockPos blockpos = blockhitresult.m_82425_();
                if (!this.f_91073_.m_46859_(blockpos)) {
                    InputEvent.ClickInputEvent inputEvent = ForgeHooksClient.onClickInput((int)0, (KeyMapping)this.f_91066_.f_92096_, (InteractionHand)InteractionHand.MAIN_HAND);
                    if (inputEvent.isCanceled()) {
                        if (inputEvent.shouldSwingHand()) {
                            this.f_91061_.addBlockHitEffects(blockpos, blockhitresult);
                            this.f_91074_.m_6674_(InteractionHand.MAIN_HAND);
                        }
                        return;
                    }
                    Direction direction = blockhitresult.m_82434_();
                    if (this.f_91072_.m_105283_(blockpos, direction) && inputEvent.shouldSwingHand()) {
                        this.f_91061_.addBlockHitEffects(blockpos, blockhitresult);
                        this.f_91074_.m_6674_(InteractionHand.MAIN_HAND);
                    }
                }
            } else {
                this.f_91072_.m_105276_();
            }
        }
    }

    private boolean m_202354_() {
        EntityHitResult entityHit;
        if (this.f_91078_ > 0) {
            return false;
        }
        if (this.f_91077_ == null) {
            f_90982_.error("Null returned as 'hitResult', this shouldn't happen!");
            if (this.f_91072_.m_105289_()) {
                this.f_91078_ = 10;
            }
            return false;
        }
        if (this.f_91074_.m_108637_()) {
            return false;
        }
        boolean flag = false;
        InputEvent.ClickInputEvent inputEvent = ForgeHooksClient.onClickInput((int)0, (KeyMapping)this.f_91066_.f_92096_, (InteractionHand)InteractionHand.MAIN_HAND);
        HitResult.Type hitType = this.f_91077_.m_6662_();
        HitResult hitResult = this.f_91077_;
        if (hitResult instanceof EntityHitResult && !this.f_91074_.canHit((entityHit = (EntityHitResult)hitResult).m_82443_(), 0.0)) {
            hitType = HitResult.Type.MISS;
        }
        if (!inputEvent.isCanceled()) {
            switch (hitType) {
                case ENTITY: {
                    this.f_91072_.m_105223_(this.f_91074_, ((EntityHitResult)this.f_91077_).m_82443_());
                    break;
                }
                case BLOCK: {
                    BlockHitResult blockhitresult = (BlockHitResult)this.f_91077_;
                    BlockPos blockpos = blockhitresult.m_82425_();
                    if (!this.f_91073_.m_46859_(blockpos)) {
                        this.f_91072_.m_105269_(blockpos, blockhitresult.m_82434_());
                        if (!this.f_91073_.m_8055_(blockpos).m_60795_()) break;
                        flag = true;
                        break;
                    }
                }
                case MISS: {
                    if (this.f_91072_.m_105289_()) {
                        this.f_91078_ = 10;
                    }
                    this.f_91074_.m_36334_();
                    ForgeHooks.onEmptyLeftClick((Player)this.f_91074_);
                }
            }
        }
        if (inputEvent.shouldSwingHand()) {
            this.f_91074_.m_6674_(InteractionHand.MAIN_HAND);
        }
        return flag;
    }

    private void m_91277_() {
        if (!this.f_91072_.m_105296_()) {
            this.f_91011_ = 4;
            if (!this.f_91074_.m_108637_()) {
                if (this.f_91077_ == null) {
                    f_90982_.warn("Null returned as 'hitResult', this shouldn't happen!");
                }
                for (InteractionHand interactionhand : InteractionHand.values()) {
                    InteractionResult interactionresult2;
                    InputEvent.ClickInputEvent inputEvent = ForgeHooksClient.onClickInput((int)1, (KeyMapping)this.f_91066_.f_92095_, (InteractionHand)interactionhand);
                    if (inputEvent.isCanceled()) {
                        if (inputEvent.shouldSwingHand()) {
                            this.f_91074_.m_6674_(interactionhand);
                        }
                        return;
                    }
                    ItemStack itemstack = this.f_91074_.m_21120_(interactionhand);
                    if (this.f_91077_ != null) {
                        switch (this.f_91077_.m_6662_()) {
                            case ENTITY: {
                                EntityHitResult entityhitresult = (EntityHitResult)this.f_91077_;
                                Entity entity = entityhitresult.m_82443_();
                                if (!this.f_91073_.m_6857_().m_61937_(entity.m_142538_())) {
                                    return;
                                }
                                if (!this.f_91074_.canInteractWith(entityhitresult.m_82443_(), 0.0)) break;
                                InteractionResult interactionresult = this.f_91072_.m_105230_(this.f_91074_, entity, entityhitresult, interactionhand);
                                if (!interactionresult.m_19077_()) {
                                    interactionresult = this.f_91072_.m_105226_(this.f_91074_, entity, interactionhand);
                                }
                                if (!interactionresult.m_19077_()) break;
                                if (interactionresult.m_19080_() && inputEvent.shouldSwingHand()) {
                                    this.f_91074_.m_6674_(interactionhand);
                                }
                                return;
                            }
                            case BLOCK: {
                                BlockHitResult blockhitresult = (BlockHitResult)this.f_91077_;
                                int i = itemstack.m_41613_();
                                InteractionResult interactionresult1 = this.f_91072_.m_105262_(this.f_91074_, this.f_91073_, interactionhand, blockhitresult);
                                if (interactionresult1.m_19077_()) {
                                    if (interactionresult1.m_19080_()) {
                                        if (inputEvent.shouldSwingHand()) {
                                            this.f_91074_.m_6674_(interactionhand);
                                        }
                                        if (!itemstack.m_41619_() && (itemstack.m_41613_() != i || this.f_91072_.m_105290_())) {
                                            this.f_91063_.f_109055_.m_109320_(interactionhand);
                                        }
                                    }
                                    return;
                                }
                                if (interactionresult1 != InteractionResult.FAIL) break;
                                return;
                            }
                        }
                    }
                    if (itemstack.m_41619_() && (this.f_91077_ == null || this.f_91077_.m_6662_() == HitResult.Type.MISS)) {
                        ForgeHooks.onEmptyClick((Player)this.f_91074_, (InteractionHand)interactionhand);
                    }
                    if (itemstack.m_41619_() || !(interactionresult2 = this.f_91072_.m_105235_(this.f_91074_, this.f_91073_, interactionhand)).m_19077_()) continue;
                    if (interactionresult2.m_19080_()) {
                        this.f_91074_.m_6674_(interactionhand);
                    }
                    this.f_91063_.f_109055_.m_109320_(interactionhand);
                    return;
                }
            }
        }
    }

    public MusicManager m_91397_() {
        return this.f_91044_;
    }

    public void m_91398_() {
        if (this.f_91011_ > 0) {
            --this.f_91011_;
        }
        ForgeEventFactory.onPreClientTick();
        this.f_91026_.m_6180_("gui");
        this.f_91065_.m_193832_(this.f_91012_);
        this.f_91026_.m_7238_();
        this.f_91063_.m_109087_(1.0f);
        this.f_91005_.m_120578_(this.f_91073_, this.f_91077_);
        this.f_91026_.m_6180_("gameMode");
        if (!this.f_91012_ && this.f_91073_ != null) {
            this.f_91072_.m_105287_();
        }
        this.f_91026_.m_6182_("textures");
        if (this.f_91073_ != null) {
            this.f_90987_.m_7673_();
        }
        if (this.f_91080_ == null && this.f_91074_ != null) {
            if (this.f_91074_.m_21224_() && !(this.f_91080_ instanceof DeathScreen)) {
                this.m_91152_(null);
            } else if (this.f_91074_.m_5803_() && this.f_91073_ != null) {
                this.m_91152_((Screen)new InBedChatScreen());
            }
        } else {
            Screen $$4 = this.f_91080_;
            if ($$4 instanceof InBedChatScreen) {
                InBedChatScreen inbedchatscreen = (InBedChatScreen)$$4;
                if (!this.f_91074_.m_5803_()) {
                    inbedchatscreen.m_193839_();
                }
            }
        }
        if (this.f_91080_ != null) {
            this.f_91078_ = 10000;
        }
        if (this.f_91080_ != null) {
            Screen.m_96579_(() -> this.f_91080_.m_96624_(), "Ticking screen", ((Object)((Object)this.f_91080_)).getClass().getCanonicalName());
        }
        if (!this.f_91066_.f_92063_) {
            this.f_91065_.m_93091_();
        }
        if (this.f_91081_ == null && (this.f_91080_ == null || this.f_91080_.f_96546_)) {
            this.f_91026_.m_6182_("Keybindings");
            this.m_91279_();
            if (this.f_91078_ > 0) {
                --this.f_91078_;
            }
        }
        if (this.f_91073_ != null) {
            this.f_91026_.m_6182_("gameRenderer");
            if (!this.f_91012_) {
                this.f_91063_.m_109148_();
            }
            this.f_91026_.m_6182_("levelRenderer");
            if (!this.f_91012_) {
                this.f_91060_.m_109823_();
            }
            this.f_91026_.m_6182_("level");
            if (!this.f_91012_) {
                if (this.f_91073_.m_104819_() > 0) {
                    this.f_91073_.m_6580_(this.f_91073_.m_104819_() - 1);
                }
                this.f_91073_.m_104804_();
            }
        } else if (this.f_91063_.m_109149_() != null) {
            this.f_91063_.m_109086_();
        }
        if (!this.f_91012_) {
            this.f_91044_.m_120183_();
        }
        this.f_91043_.m_120389_(this.f_91012_);
        if (this.f_91073_ != null) {
            if (!this.f_91012_) {
                if (!this.f_91066_.f_92031_ && this.m_91278_()) {
                    TranslatableComponent component = new TranslatableComponent("tutorial.socialInteractions.title");
                    TranslatableComponent component1 = new TranslatableComponent("tutorial.socialInteractions.description", Tutorial.m_120592_((String)"socialInteractions"));
                    this.f_91025_ = new TutorialToast(TutorialToast.Icons.SOCIAL_INTERACTIONS, (Component)component, (Component)component1, true);
                    this.f_91005_.m_120572_(this.f_91025_, 160);
                    this.f_91066_.f_92031_ = true;
                    this.f_91066_.m_92169_();
                }
                this.f_91005_.m_120596_();
                ForgeEventFactory.onPreWorldTick((Level)this.f_91073_, () -> true);
                try {
                    this.f_91073_.m_104726_(() -> true);
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.m_127521_(throwable, "Exception in world tick");
                    if (this.f_91073_ == null) {
                        CrashReportCategory crashreportcategory = crashreport.m_127514_("Affected level");
                        crashreportcategory.m_128159_("Problem", "Level is null!");
                    } else {
                        this.f_91073_.m_6026_(crashreport);
                    }
                    throw new ReportedException(crashreport);
                }
                ForgeEventFactory.onPostWorldTick((Level)this.f_91073_, () -> true);
            }
            this.f_91026_.m_6182_("animateTick");
            if (!this.f_91012_ && this.f_91073_ != null) {
                this.f_91073_.m_104784_(this.f_91074_.m_146903_(), this.f_91074_.m_146904_(), this.f_91074_.m_146907_());
            }
            this.f_91026_.m_6182_("particles");
            if (!this.f_91012_) {
                this.f_91061_.m_107388_();
            }
        } else if (this.f_91009_ != null) {
            this.f_91026_.m_6182_("pendingConnection");
            this.f_91009_.m_129483_();
        }
        this.f_91026_.m_6182_("keyboard");
        this.f_91068_.m_90931_();
        this.f_91026_.m_7238_();
        ForgeEventFactory.onPostClientTick();
    }

    private boolean m_91278_() {
        return !this.f_91010_ || this.f_91007_ != null && this.f_91007_.m_6992_();
    }

    private void m_91279_() {
        while (this.f_91066_.f_92103_.m_90859_()) {
            CameraType cameratype = this.f_91066_.m_92176_();
            this.f_91066_.m_92157_(this.f_91066_.m_92176_().m_90614_());
            if (cameratype.m_90612_() != this.f_91066_.m_92176_().m_90612_()) {
                this.f_91063_.m_109106_(this.f_91066_.m_92176_().m_90612_() ? this.m_91288_() : null);
            }
            this.f_91060_.m_109826_();
        }
        while (this.f_91066_.f_92104_.m_90859_()) {
            this.f_91066_.f_92067_ = !this.f_91066_.f_92067_;
        }
        for (int i = 0; i < 9; ++i) {
            boolean flag = this.f_91066_.f_92057_.m_90857_();
            boolean flag1 = this.f_91066_.f_92058_.m_90857_();
            if (!this.f_91066_.f_92056_[i].m_90859_()) continue;
            if (this.f_91074_.m_5833_()) {
                this.f_91065_.m_93085_().m_94771_(i);
                continue;
            }
            if (!this.f_91074_.m_7500_() || this.f_91080_ != null || !flag1 && !flag) {
                this.f_91074_.m_150109_().f_35977_ = i;
                continue;
            }
            CreativeModeInventoryScreen.m_98598_(this, i, flag1, flag);
        }
        while (this.f_91066_.f_92101_.m_90859_()) {
            if (!this.m_91278_()) {
                this.f_91074_.m_5661_(f_90984_, true);
                NarratorChatListener.f_93311_.m_168785_(f_90984_);
                continue;
            }
            if (this.f_91025_ != null) {
                this.f_91005_.m_120570_(this.f_91025_);
                this.f_91025_ = null;
            }
            this.m_91152_((Screen)new SocialInteractionsScreen());
        }
        while (this.f_91066_.f_92092_.m_90859_()) {
            if (this.f_91072_.m_105292_()) {
                this.f_91074_.m_108628_();
                continue;
            }
            this.f_91005_.m_120564_();
            this.m_91152_((Screen)new InventoryScreen((Player)this.f_91074_));
        }
        while (this.f_91066_.f_92055_.m_90859_()) {
            this.m_91152_(new AdvancementsScreen(this.f_91074_.f_108617_.m_105145_()));
        }
        while (this.f_91066_.f_92093_.m_90859_()) {
            if (this.f_91074_.m_5833_()) continue;
            this.m_91403_().m_104955_((Packet<?>)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.SWAP_ITEM_WITH_OFFHAND, BlockPos.f_121853_, Direction.DOWN));
        }
        while (this.f_91066_.f_92094_.m_90859_()) {
            if (this.f_91074_.m_5833_() || !this.f_91074_.m_108700_(Screen.m_96637_())) continue;
            this.f_91074_.m_6674_(InteractionHand.MAIN_HAND);
        }
        while (this.f_91066_.f_92098_.m_90859_()) {
            this.m_91326_("");
        }
        if (this.f_91080_ == null && this.f_91081_ == null && this.f_91066_.f_92100_.m_90859_()) {
            this.m_91326_("/");
        }
        boolean flag2 = false;
        if (this.f_91074_.m_6117_()) {
            if (!this.f_91066_.f_92095_.m_90857_()) {
                this.f_91072_.m_105277_(this.f_91074_);
            }
            while (this.f_91066_.f_92096_.m_90859_()) {
            }
            while (this.f_91066_.f_92095_.m_90859_()) {
            }
            while (this.f_91066_.f_92097_.m_90859_()) {
            }
        } else {
            while (this.f_91066_.f_92096_.m_90859_()) {
                flag2 |= this.m_202354_();
            }
            while (this.f_91066_.f_92095_.m_90859_()) {
                this.m_91277_();
            }
            while (this.f_91066_.f_92097_.m_90859_()) {
                this.m_91280_();
            }
        }
        if (this.f_91066_.f_92095_.m_90857_() && this.f_91011_ == 0 && !this.f_91074_.m_6117_()) {
            this.m_91277_();
        }
        this.m_91386_(this.f_91080_ == null && !flag2 && this.f_91066_.f_92096_.m_90857_() && this.f_91067_.m_91600_());
    }

    public ClientTelemetryManager m_193590_() {
        return new ClientTelemetryManager(this, this.f_193584_, this.f_90998_.m_193806_(), this.f_90998_.m_193805_(), this.f_193582_);
    }

    public void m_91200_(String p_91201_) {
        this.doLoadLevel(p_91201_, WorldStem.DataPackConfigSupplier::m_206928_, WorldStem.WorldDataSupplier::m_206954_, false, ExperimentalDialogType.BACKUP, false);
    }

    public void m_205185_(String p_205186_, LevelSettings p_205187_, RegistryAccess p_205188_, WorldGenSettings p_205189_) {
        this.doLoadLevel(p_205186_, p_210684_ -> p_205187_::m_46934_, p_210718_ -> (p_210712_, p_210713_) -> {
            RegistryAccess.Writable registryaccess$writable = RegistryAccess.m_206197_();
            RegistryOps dynamicops = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)p_205188_);
            RegistryOps dynamicops1 = RegistryOps.m_206813_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess.Writable)registryaccess$writable, (ResourceManager)p_210712_);
            DataResult dataresult = WorldGenSettings.f_64600_.encodeStart((DynamicOps)dynamicops, (Object)p_205189_).setLifecycle(Lifecycle.stable()).flatMap(arg_0 -> Minecraft.lambda$createLevel$35((DynamicOps)dynamicops1, arg_0));
            WorldGenSettings worldgensettings = (WorldGenSettings)dataresult.getOrThrow(false, Util.m_137489_("Error reading worldgen settings after loading data packs: ", arg_0 -> ((Logger)f_90982_).error(arg_0)));
            return Pair.of((Object)new PrimaryLevelData(p_205187_, worldgensettings, dataresult.lifecycle()), (Object)registryaccess$writable.m_203557_());
        }, false, ExperimentalDialogType.CREATE, true);
    }

    private void doLoadLevel(String p_205206_, Function<LevelStorageSource.LevelStorageAccess, WorldStem.DataPackConfigSupplier> p_205207_, Function<LevelStorageSource.LevelStorageAccess, WorldStem.WorldDataSupplier> p_205208_, boolean p_205209_, ExperimentalDialogType p_205210_, boolean creating) {
        PrimaryLevelData pld;
        boolean skipConfirmation;
        WorldStem worldstem;
        LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess;
        try {
            levelstoragesource$levelstorageaccess = this.f_91031_.m_78260_(p_205206_);
        }
        catch (IOException ioexception2) {
            f_90982_.warn("Failed to read level {} data", (Object)p_205206_, (Object)ioexception2);
            SystemToast.m_94852_((Minecraft)this, (String)p_205206_);
            this.m_91152_(null);
            return;
        }
        PackRepository packrepository = Minecraft.m_205142_(levelstoragesource$levelstorageaccess);
        try {
            if (!creating) {
                levelstoragesource$levelstorageaccess.readAdditionalLevelSaveData();
            }
            worldstem = this.m_205125_(packrepository, p_205209_, p_205207_.apply(levelstoragesource$levelstorageaccess), p_205208_.apply(levelstoragesource$levelstorageaccess));
        }
        catch (Exception exception) {
            f_90982_.warn("Failed to load datapacks, can't proceed with server load", (Throwable)exception);
            this.m_91152_((Screen)new DatapackLoadFailureScreen(() -> this.doLoadLevel(p_205206_, p_205207_, p_205208_, true, p_205210_, creating)));
            try {
                packrepository.close();
                levelstoragesource$levelstorageaccess.close();
            }
            catch (IOException ioexception) {
                f_90982_.warn("Failed to unlock access to level {}", (Object)p_205206_, (Object)ioexception);
            }
            return;
        }
        WorldData worlddata = worldstem.f_206895_();
        boolean flag = worlddata.m_5961_().m_64670_();
        boolean flag1 = worlddata.m_5754_() != Lifecycle.stable();
        boolean bl = skipConfirmation = worlddata instanceof PrimaryLevelData && (pld = (PrimaryLevelData)worlddata).hasConfirmedExperimentalWarning();
        if (skipConfirmation || p_205210_ == ExperimentalDialogType.NONE || !flag && !flag1) {
            this.m_91399_();
            this.f_90999_.set(null);
            try {
                RegistryAccess.Frozen registryaccess$frozen = worldstem.f_206894_();
                levelstoragesource$levelstorageaccess.m_78287_(registryaccess$frozen, worlddata);
                worldstem.m_206901_();
                YggdrasilAuthenticationService yggdrasilauthenticationservice = new YggdrasilAuthenticationService(this.f_91030_);
                MinecraftSessionService minecraftsessionservice = yggdrasilauthenticationservice.createMinecraftSessionService();
                GameProfileRepository gameprofilerepository = yggdrasilauthenticationservice.createProfileRepository();
                GameProfileCache gameprofilecache = new GameProfileCache(gameprofilerepository, new File(this.f_91069_, MinecraftServer.f_129742_.getName()));
                gameprofilecache.m_143974_((Executor)((Object)this));
                SkullBlockEntity.m_196700_((GameProfileCache)gameprofilecache, (MinecraftSessionService)minecraftsessionservice, (Executor)((Object)this));
                GameProfileCache.m_11004_((boolean)false);
                this.f_91007_ = MinecraftServer.m_129872_(p_210695_ -> new IntegratedServer((Thread)p_210695_, this, levelstoragesource$levelstorageaccess, packrepository, worldstem, minecraftsessionservice, gameprofilerepository, gameprofilecache, p_210795_ -> {
                    StoringChunkProgressListener storingchunkprogresslistener = new StoringChunkProgressListener(p_210795_ + 0);
                    this.f_90999_.set(storingchunkprogresslistener);
                    return ProcessorChunkProgressListener.m_143583_((ChunkProgressListener)storingchunkprogresslistener, this.f_91023_::add);
                }));
                this.f_91010_ = true;
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.m_127521_(throwable, "Starting integrated server");
                CrashReportCategory crashreportcategory = crashreport.m_127514_("Starting integrated server");
                crashreportcategory.m_128159_("Level ID", p_205206_);
                crashreportcategory.m_128159_("Level Name", worlddata.m_5462_());
                throw new ReportedException(crashreport);
            }
            while (this.f_90999_.get() == null) {
                Thread.yield();
            }
            LevelLoadingScreen levelloadingscreen = new LevelLoadingScreen(this.f_90999_.get());
            this.m_91152_((Screen)levelloadingscreen);
            this.f_91026_.m_6180_("waitForServer");
            while (!this.f_91007_.m_129920_()) {
                levelloadingscreen.m_96624_();
                this.m_91383_(false);
                try {
                    Thread.sleep(16L);
                }
                catch (InterruptedException crashreport) {
                    // empty catch block
                }
                if (this.f_91020_ == null) continue;
                Minecraft.m_91332_(this.f_91020_.get());
                return;
            }
            this.f_91026_.m_7238_();
            SocketAddress socketaddress = this.f_91007_.m_129919_().m_9708_();
            Connection connection = Connection.m_129493_(socketaddress);
            connection.m_129505_((PacketListener)new ClientHandshakePacketListenerImpl(connection, this, null, p_210793_ -> {}));
            connection.m_129512_(new ClientIntentionPacket(socketaddress.toString(), 0, ConnectionProtocol.LOGIN));
            GameProfile gameProfile = this.m_91094_().m_92548_();
            if (!this.m_91094_().hasCachedProperties()) {
                gameProfile = this.f_91048_.fillProfileProperties(gameProfile, true);
                this.m_91094_().setProperties(gameProfile.getProperties());
            }
            connection.m_129512_((Packet<?>)new ServerboundHelloPacket(gameProfile));
            this.f_91009_ = connection;
        } else {
            if (flag) {
                this.m_91143_(p_205210_, p_205206_, flag, () -> this.doLoadLevel(p_205206_, p_205207_, p_205208_, p_205209_, ExperimentalDialogType.NONE, creating));
            } else {
                ForgeHooksClient.createWorldConfirmationScreen((LevelStorageSource)this.f_91031_, (String)p_205206_, (boolean)creating, p_205208_, wds -> () -> this.doLoadLevel(p_205206_, p_205207_, (Function<LevelStorageSource.LevelStorageAccess, WorldStem.WorldDataSupplier>)wds, p_205209_, ExperimentalDialogType.NONE, creating));
            }
            worldstem.close();
            try {
                packrepository.close();
                levelstoragesource$levelstorageaccess.close();
            }
            catch (IOException ioexception1) {
                f_90982_.warn("Failed to unlock access to level {}", (Object)p_205206_, (Object)ioexception1);
            }
        }
    }

    private void m_91143_(ExperimentalDialogType p_91144_, String p_91145_, boolean p_91146_, Runnable p_91147_) {
        if (p_91144_ == ExperimentalDialogType.BACKUP) {
            TranslatableComponent component1;
            TranslatableComponent component;
            if (p_91146_) {
                component = new TranslatableComponent("selectWorld.backupQuestion.customized");
                component1 = new TranslatableComponent("selectWorld.backupWarning.customized");
            } else {
                component = new TranslatableComponent("selectWorld.backupQuestion.experimental");
                component1 = new TranslatableComponent("selectWorld.backupWarning.experimental");
            }
            this.m_91152_((Screen)new BackupConfirmScreen((Screen)null, (p_210729_, p_210730_) -> {
                if (p_210729_) {
                    EditWorldScreen.m_101260_((LevelStorageSource)this.f_91031_, (String)p_91145_);
                }
                p_91147_.run();
            }, (Component)component, (Component)component1, false));
        } else {
            this.m_91152_((Screen)new ConfirmScreen(p_210725_ -> {
                if (p_210725_) {
                    p_91147_.run();
                } else {
                    this.m_91152_(null);
                    try (LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = this.f_91031_.m_78260_(p_91145_);){
                        levelstoragesource$levelstorageaccess.m_78311_();
                    }
                    catch (IOException ioexception) {
                        SystemToast.m_94866_((Minecraft)this, (String)p_91145_);
                        f_90982_.error("Failed to delete world {}", (Object)p_91145_, (Object)ioexception);
                    }
                }
            }, (Component)new TranslatableComponent("selectWorld.backupQuestion.experimental"), (Component)new TranslatableComponent("selectWorld.backupWarning.experimental"), CommonComponents.f_130659_, CommonComponents.f_130656_));
        }
    }

    public WorldStem m_205152_(LevelStorageSource.LevelStorageAccess p_205153_, boolean p_205154_) throws ExecutionException, InterruptedException {
        PackRepository packrepository = Minecraft.m_205142_(p_205153_);
        return this.m_205125_(packrepository, p_205154_, WorldStem.DataPackConfigSupplier.m_206928_((LevelStorageSource.LevelStorageAccess)p_205153_), WorldStem.WorldDataSupplier.m_206954_((LevelStorageSource.LevelStorageAccess)p_205153_));
    }

    public WorldStem m_205125_(PackRepository p_205126_, boolean p_205127_, WorldStem.DataPackConfigSupplier p_205128_, WorldStem.WorldDataSupplier p_205129_) throws InterruptedException, ExecutionException {
        try {
            WorldStem.InitConfig worldstem$initconfig = new WorldStem.InitConfig(p_205126_, Commands.CommandSelection.INTEGRATED, 2, p_205127_);
            CompletableFuture completablefuture = WorldStem.m_206911_((WorldStem.InitConfig)worldstem$initconfig, (WorldStem.DataPackConfigSupplier)p_205128_, (WorldStem.WorldDataSupplier)p_205129_, (Executor)Util.m_183991_(), (Executor)((Object)this));
            this.m_18701_(completablefuture::isDone);
            return (WorldStem)completablefuture.get();
        }
        catch (InterruptedException | ExecutionException interruptedexception) {
            p_205126_.close();
            throw interruptedexception;
        }
    }

    private static PackRepository m_205142_(LevelStorageSource.LevelStorageAccess p_205143_) {
        return new PackRepository(PackType.SERVER_DATA, new RepositorySource[]{new ServerPacksSource(), new FolderRepositorySource(p_205143_.m_78283_(LevelResource.f_78180_).toFile(), PackSource.f_10529_)});
    }

    public void m_91156_(ClientLevel p_91157_) {
        if (this.f_91073_ != null) {
            MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Unload((LevelAccessor)this.f_91073_));
        }
        ProgressScreen progressscreen = new ProgressScreen(true);
        progressscreen.m_6309_((Component)new TranslatableComponent("connect.joining"));
        this.m_91362_((Screen)progressscreen);
        this.f_91073_ = p_91157_;
        this.m_91324_(p_91157_);
        if (!this.f_91010_) {
            YggdrasilAuthenticationService authenticationservice = new YggdrasilAuthenticationService(this.f_91030_);
            MinecraftSessionService minecraftsessionservice = authenticationservice.createMinecraftSessionService();
            GameProfileRepository gameprofilerepository = authenticationservice.createProfileRepository();
            GameProfileCache gameprofilecache = new GameProfileCache(gameprofilerepository, new File(this.f_91069_, MinecraftServer.f_129742_.getName()));
            gameprofilecache.m_143974_((Executor)((Object)this));
            SkullBlockEntity.m_196700_((GameProfileCache)gameprofilecache, (MinecraftSessionService)minecraftsessionservice, (Executor)((Object)this));
            GameProfileCache.m_11004_((boolean)false);
        }
    }

    public void m_91399_() {
        this.m_91320_((Screen)new ProgressScreen(true));
    }

    public void m_91320_(Screen p_91321_) {
        ClientPacketListener clientpacketlistener = this.m_91403_();
        if (clientpacketlistener != null) {
            this.m_18698_();
            clientpacketlistener.m_105140_();
        }
        this.f_91006_.m_194060_();
        IntegratedServer integratedserver = this.f_91007_;
        this.f_91007_ = null;
        this.f_91063_.m_109150_();
        ForgeHooksClient.firePlayerLogout((MultiPlayerGameMode)this.f_91072_, (LocalPlayer)this.f_91074_);
        this.f_91072_ = null;
        NarratorChatListener.f_93311_.m_93328_();
        this.m_91362_(p_91321_);
        if (this.f_91073_ != null) {
            MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Unload((LevelAccessor)this.f_91073_));
            if (integratedserver != null) {
                this.f_91026_.m_6180_("waitForServer");
                while (!integratedserver.m_129782_()) {
                    this.m_91383_(false);
                }
                this.f_91026_.m_7238_();
            }
            this.f_91037_.m_118586_();
            this.f_91065_.m_93089_();
            this.f_91008_ = null;
            this.f_91010_ = false;
            ForgeHooksClient.handleClientLevelClosing((ClientLevel)this.f_91073_);
            this.f_91004_.m_90740_();
        }
        this.f_91073_ = null;
        this.m_91324_(null);
        this.f_91074_ = null;
        SkullBlockEntity.m_196704_();
    }

    private void m_91362_(Screen p_91363_) {
        this.f_91026_.m_6180_("forcedTick");
        this.f_91043_.m_120405_();
        this.f_91075_ = null;
        this.f_91009_ = null;
        this.m_91152_(p_91363_);
        this.m_91383_(false);
        this.f_91026_.m_7238_();
    }

    public void m_91346_(Screen p_91347_) {
        this.f_91026_.m_6180_("forcedTick");
        this.m_91152_(p_91347_);
        this.m_91383_(false);
        this.f_91026_.m_7238_();
    }

    private void m_91324_(@Nullable ClientLevel p_91325_) {
        this.f_91060_.m_109701_(p_91325_);
        this.f_91061_.m_107342_(p_91325_);
        this.f_167845_.m_112257_((Level)p_91325_);
        this.m_91341_();
    }

    public boolean m_91400_() {
        return this.f_91034_ && this.f_193584_.properties().flag(UserApiService.UserFlag.SERVERS_ALLOWED);
    }

    public boolean m_168021_() {
        return this.f_193584_.properties().flag(UserApiService.UserFlag.REALMS_ALLOWED);
    }

    public boolean m_91246_(UUID p_91247_) {
        if (this.m_168022_().m_142594_(false)) {
            return this.f_91006_.m_100684_(p_91247_);
        }
        return (this.f_91074_ == null || !p_91247_.equals(this.f_91074_.m_142081_())) && !p_91247_.equals(Util.f_137441_);
    }

    public ChatStatus m_168022_() {
        if (this.f_91066_.f_92119_ == ChatVisiblity.HIDDEN) {
            return ChatStatus.DISABLED_BY_OPTIONS;
        }
        if (!this.f_91035_) {
            return ChatStatus.DISABLED_BY_LAUNCHER;
        }
        return !this.f_193584_.properties().flag(UserApiService.UserFlag.CHAT_ALLOWED) ? ChatStatus.DISABLED_BY_PROFILE : ChatStatus.ENABLED;
    }

    public final boolean m_91402_() {
        return this.f_91033_;
    }

    @Nullable
    public ClientPacketListener m_91403_() {
        return this.f_91074_ == null ? null : this.f_91074_.f_108617_;
    }

    public static boolean m_91404_() {
        return !Minecraft.f_90981_.f_91066_.f_92062_;
    }

    public static boolean m_91405_() {
        return Minecraft.f_90981_.f_91066_.f_92115_.m_90773_() >= GraphicsStatus.FANCY.m_90773_();
    }

    public static boolean m_91085_() {
        return !Minecraft.f_90981_.f_91063_.m_172715_() && Minecraft.f_90981_.f_91066_.f_92115_.m_90773_() >= GraphicsStatus.FABULOUS.m_90773_();
    }

    public static boolean m_91086_() {
        return Minecraft.f_90981_.f_91066_.f_92116_ != AmbientOcclusionStatus.OFF;
    }

    private void m_91280_() {
        if (this.f_91077_ != null && this.f_91077_.m_6662_() != HitResult.Type.MISS && !ForgeHooksClient.onClickInput((int)2, (KeyMapping)this.f_91066_.f_92097_, (InteractionHand)InteractionHand.MAIN_HAND).isCanceled()) {
            ForgeHooks.onPickBlock((HitResult)this.f_91077_, (Player)this.f_91074_, (Level)this.f_91073_);
        }
    }

    public ItemStack m_91122_(ItemStack p_91123_, BlockEntity p_91124_) {
        CompoundTag compoundtag = p_91124_.m_187480_();
        if (p_91123_.m_41720_() instanceof PlayerHeadItem && compoundtag.m_128441_("SkullOwner")) {
            CompoundTag compoundtag2 = compoundtag.m_128469_("SkullOwner");
            p_91123_.m_41784_().m_128365_("SkullOwner", compoundtag2);
            return p_91123_;
        }
        BlockItem.m_186338_(p_91123_, p_91124_.m_58903_(), compoundtag);
        CompoundTag compoundtag1 = new CompoundTag();
        ListTag listtag = new ListTag();
        listtag.add((Object)StringTag.m_129297_("\"(+NBT)\""));
        compoundtag1.m_128365_("Lore", (Tag)listtag);
        p_91123_.m_41700_("display", compoundtag1);
        return p_91123_;
    }

    public CrashReport m_91354_(CrashReport p_91355_) {
        SystemReport systemreport = p_91355_.m_178626_();
        Minecraft.m_167850_(systemreport, this, this.f_91039_, this.f_91001_, this.f_91066_);
        if (this.f_91073_ != null) {
            this.f_91073_.m_6026_(p_91355_);
        }
        if (this.f_91007_ != null) {
            this.f_91007_.m_177935_(systemreport);
        }
        this.f_167847_.m_168562_(p_91355_);
        return p_91355_;
    }

    public static void m_167872_(@Nullable Minecraft p_167873_, @Nullable LanguageManager p_167874_, String p_167875_, @Nullable Options p_167876_, CrashReport p_167877_) {
        SystemReport systemreport = p_167877_.m_178626_();
        Minecraft.m_167850_(systemreport, p_167873_, p_167874_, p_167875_, p_167876_);
    }

    private static SystemReport m_167850_(SystemReport p_167851_, @Nullable Minecraft p_167852_, @Nullable LanguageManager p_167853_, String p_167854_, Options p_167855_) {
        p_167851_.m_143522_("Launched Version", () -> p_167854_);
        p_167851_.m_143522_("Backend library", RenderSystem::m_69517_);
        p_167851_.m_143522_("Backend API", RenderSystem::m_69516_);
        p_167851_.m_143522_("Window size", () -> p_167852_ != null ? p_167852_.f_90990_.m_85441_() + "x" + p_167852_.f_90990_.m_85442_() : "<not initialized>");
        p_167851_.m_143522_("GL Caps", RenderSystem::m_69518_);
        p_167851_.m_143522_("GL debug messages", () -> GlDebug.m_166226_() ? String.join((CharSequence)"\n", GlDebug.m_166225_()) : "<disabled>");
        p_167851_.m_143522_("Using VBOs", () -> "Yes");
        p_167851_.m_143522_("Is Modded", () -> Minecraft.m_193589_().m_184605_());
        p_167851_.m_143519_("Type", "Client (map_client.txt)");
        if (p_167855_ != null) {
            String s;
            if (f_90981_ != null && (s = f_90981_.m_91105_().m_109256_()) != null) {
                p_167851_.m_143519_("GPU Warnings", s);
            }
            p_167851_.m_143519_("Graphics mode", p_167855_.f_92115_.toString());
            p_167851_.m_143522_("Resource Packs", () -> {
                StringBuilder stringbuilder = new StringBuilder();
                for (String s1 : p_167855_.f_92117_) {
                    if (stringbuilder.length() > 0) {
                        stringbuilder.append(", ");
                    }
                    stringbuilder.append(s1);
                    if (!p_167855_.f_92118_.contains(s1)) continue;
                    stringbuilder.append(" (incompatible)");
                }
                return stringbuilder.toString();
            });
        }
        if (p_167853_ != null) {
            p_167851_.m_143522_("Current Language", () -> p_167853_.m_118983_().toString());
        }
        p_167851_.m_143522_("CPU", GlUtil::m_84819_);
        return p_167851_;
    }

    public static Minecraft m_91087_() {
        return f_90981_;
    }

    public CompletableFuture<Void> m_91088_() {
        return this.m_18691_(() -> this.m_91391_()).thenCompose(p_210747_ -> p_210747_);
    }

    public void m_91158_(@Nullable ServerData p_91159_) {
        this.f_91008_ = p_91159_;
    }

    @Nullable
    public ServerData m_91089_() {
        return this.f_91008_;
    }

    public boolean m_91090_() {
        return this.f_91010_;
    }

    public boolean m_91091_() {
        return this.f_91010_ && this.f_91007_ != null;
    }

    @Nullable
    public IntegratedServer m_91092_() {
        return this.f_91007_;
    }

    public User m_91094_() {
        return this.f_90998_;
    }

    public PropertyMap m_91095_() {
        if (this.f_90986_.isEmpty()) {
            GameProfile gameprofile = this.m_91108_().fillProfileProperties(this.f_90998_.m_92548_(), false);
            this.f_90986_.putAll((Multimap)gameprofile.getProperties());
        }
        return this.f_90986_;
    }

    public Proxy m_91096_() {
        return this.f_91030_;
    }

    public TextureManager m_91097_() {
        return this.f_90987_;
    }

    public ResourceManager m_91098_() {
        return this.f_91036_;
    }

    public PackRepository m_91099_() {
        return this.f_91038_;
    }

    public ClientPackSource m_91100_() {
        return this.f_91037_;
    }

    public File m_91101_() {
        return this.f_90985_;
    }

    public LanguageManager m_91102_() {
        return this.f_91039_;
    }

    public Function<ResourceLocation, TextureAtlasSprite> m_91258_(ResourceLocation p_91259_) {
        return this.f_91051_.m_119428_(p_91259_)::m_118316_;
    }

    public boolean m_91103_() {
        return this.f_91032_;
    }

    public boolean m_91104_() {
        return this.f_91012_;
    }

    public GpuWarnlistManager m_91105_() {
        return this.f_91047_;
    }

    public SoundManager m_91106_() {
        return this.f_91043_;
    }

    public Music m_91107_() {
        if (this.f_91080_ instanceof WinScreen) {
            return Musics.f_11647_;
        }
        if (this.f_91074_ != null) {
            if (this.f_91074_.f_19853_.m_46472_() == Level.f_46430_) {
                return this.f_91065_.m_93090_().m_93713_() ? Musics.f_11648_ : Musics.f_11649_;
            }
            Holder holder = this.f_91074_.f_19853_.m_204166_(this.f_91074_.m_142538_());
            Biome.BiomeCategory biome$biomecategory = Biome.m_204183_(holder);
            if (!this.f_91044_.m_120187_(Musics.f_11650_) && (!this.f_91074_.m_5842_() || biome$biomecategory != Biome.BiomeCategory.OCEAN && biome$biomecategory != Biome.BiomeCategory.RIVER)) {
                return this.f_91074_.f_19853_.m_46472_() != Level.f_46429_ && this.f_91074_.m_150110_().f_35937_ && this.f_91074_.m_150110_().f_35936_ ? Musics.f_11646_ : ((Biome)((Object)holder.m_203334_())).m_47566_().orElse(Musics.f_11651_);
            }
            return Musics.f_11650_;
        }
        return Musics.f_11645_;
    }

    public MinecraftSessionService m_91108_() {
        return this.f_91048_;
    }

    public SkinManager m_91109_() {
        return this.f_91050_;
    }

    @Nullable
    public Entity m_91288_() {
        return this.f_91075_;
    }

    public void m_91118_(Entity p_91119_) {
        this.f_91075_ = p_91119_;
        this.f_91063_.m_109106_(p_91119_);
    }

    public boolean m_91314_(Entity p_91315_) {
        return p_91315_.m_142038_() || this.f_91074_ != null && this.f_91074_.m_5833_() && this.f_91066_.f_92054_.m_90857_() && p_91315_.m_6095_() == EntityType.f_20532_;
    }

    protected Thread m_6304_() {
        return this.f_91018_;
    }

    protected Runnable m_6681_(Runnable p_91376_) {
        return p_91376_;
    }

    protected boolean m_6362_(Runnable p_91365_) {
        return true;
    }

    public BlockRenderDispatcher m_91289_() {
        return this.f_91052_;
    }

    public EntityRenderDispatcher m_91290_() {
        return this.f_90994_;
    }

    public BlockEntityRenderDispatcher m_167982_() {
        return this.f_167845_;
    }

    public ItemRenderer m_91291_() {
        return this.f_90995_;
    }

    public ItemInHandRenderer m_91292_() {
        return this.f_90996_;
    }

    public <T> MutableSearchTree<T> m_91171_(SearchRegistry.Key<T> p_91172_) {
        return this.f_90997_.m_119949_(p_91172_);
    }

    public FrameTimer m_91293_() {
        return this.f_91070_;
    }

    public boolean m_91294_() {
        return this.f_91017_;
    }

    public void m_91372_(boolean p_91373_) {
        this.f_91017_ = p_91373_;
    }

    public DataFixer m_91295_() {
        return this.f_90988_;
    }

    public float m_91296_() {
        return this.f_90991_.f_92518_;
    }

    public float m_91297_() {
        return this.f_90991_.f_92519_;
    }

    public BlockColors m_91298_() {
        return this.f_91040_;
    }

    public boolean m_91299_() {
        return this.f_91074_ != null && this.f_91074_.m_36330_() || this.f_91066_.f_92047_;
    }

    public ToastComponent m_91300_() {
        return this.f_91003_;
    }

    public Tutorial m_91301_() {
        return this.f_91005_;
    }

    public boolean m_91302_() {
        return this.f_91022_;
    }

    public HotbarManager m_91303_() {
        return this.f_91000_;
    }

    public ModelManager m_91304_() {
        return this.f_91051_;
    }

    public PaintingTextureManager m_91305_() {
        return this.f_91053_;
    }

    public MobEffectTextureManager m_91306_() {
        return this.f_91054_;
    }

    public void m_7440_(boolean p_91261_) {
        this.f_91022_ = p_91261_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component m_167899_(File p_167900_, int p_167901_, int p_167902_) {
        TranslatableComponent translatablecomponent;
        int i = this.f_90990_.m_85441_();
        int j = this.f_90990_.m_85442_();
        TextureTarget rendertarget = new TextureTarget(p_167901_, p_167902_, true, f_91002_);
        float f = this.f_91074_.m_146909_();
        float f1 = this.f_91074_.m_146908_();
        float f2 = this.f_91074_.f_19860_;
        float f3 = this.f_91074_.f_19859_;
        this.f_91063_.m_172775_(false);
        try {
            this.f_91063_.m_172779_(true);
            this.f_91060_.m_173014_();
            this.f_90990_.m_166450_(p_167901_);
            this.f_90990_.m_166452_(p_167902_);
            for (int k = 0; k < 6; ++k) {
                switch (k) {
                    case 0: {
                        this.f_91074_.m_146922_(f1);
                        this.f_91074_.m_146926_(0.0f);
                        break;
                    }
                    case 1: {
                        this.f_91074_.m_146922_((f1 + 90.0f) % 360.0f);
                        this.f_91074_.m_146926_(0.0f);
                        break;
                    }
                    case 2: {
                        this.f_91074_.m_146922_((f1 + 180.0f) % 360.0f);
                        this.f_91074_.m_146926_(0.0f);
                        break;
                    }
                    case 3: {
                        this.f_91074_.m_146922_((f1 - 90.0f) % 360.0f);
                        this.f_91074_.m_146926_(0.0f);
                        break;
                    }
                    case 4: {
                        this.f_91074_.m_146922_(f1);
                        this.f_91074_.m_146926_(-90.0f);
                        break;
                    }
                    default: {
                        this.f_91074_.m_146922_(f1);
                        this.f_91074_.m_146926_(90.0f);
                    }
                }
                this.f_91074_.f_19859_ = this.f_91074_.m_146908_();
                this.f_91074_.f_19860_ = this.f_91074_.m_146909_();
                rendertarget.m_83947_(true);
                this.f_91063_.m_109089_(1.0f, 0L, new PoseStack());
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Screenshot.m_92295_(p_167900_, "panorama_" + k + ".png", (RenderTarget)rendertarget, p_210769_ -> {});
            }
            MutableComponent component = new TextComponent(p_167900_.getName()).m_130940_(ChatFormatting.UNDERLINE).m_130938_(p_210781_ -> p_210781_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, p_167900_.getAbsolutePath())));
            TranslatableComponent translatableComponent = new TranslatableComponent("screenshot.success", component);
            return translatableComponent;
        }
        catch (Exception exception) {
            f_90982_.error("Couldn't save image", (Throwable)exception);
            translatablecomponent = new TranslatableComponent("screenshot.failure", exception.getMessage());
        }
        finally {
            this.f_91074_.m_146926_(f);
            this.f_91074_.m_146922_(f1);
            this.f_91074_.f_19860_ = f2;
            this.f_91074_.f_19859_ = f3;
            this.f_91063_.m_172775_(true);
            this.f_90990_.m_166450_(i);
            this.f_90990_.m_166452_(j);
            rendertarget.m_83930_();
            this.f_91063_.m_172779_(false);
            this.f_91060_.m_173014_();
            this.m_91385_().m_83947_(true);
        }
        return translatablecomponent;
    }

    private Component m_167903_(File p_167904_, int p_167905_, int p_167906_, int p_167907_, int p_167908_) {
        try {
            ByteBuffer bytebuffer = GlUtil.m_166247_((int)(p_167905_ * p_167906_ * 3));
            Screenshot screenshot = new Screenshot(p_167904_, p_167907_, p_167908_, p_167906_);
            float f = (float)p_167907_ / (float)p_167905_;
            float f1 = (float)p_167908_ / (float)p_167906_;
            float f2 = f > f1 ? f : f1;
            for (int i = (p_167908_ - 1) / p_167906_ * p_167906_; i >= 0; i -= p_167906_) {
                for (int j = 0; j < p_167907_; j += p_167905_) {
                    RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
                    float f3 = (float)(p_167907_ - p_167905_) / 2.0f * 2.0f - (float)(j * 2);
                    float f4 = (float)(p_167908_ - p_167906_) / 2.0f * 2.0f - (float)(i * 2);
                    this.f_91063_.m_172718_(f2, f3 /= (float)p_167905_, f4 /= (float)p_167906_);
                    bytebuffer.clear();
                    RenderSystem.m_69854_((int)3333, (int)1);
                    RenderSystem.m_69854_((int)3317, (int)1);
                    RenderSystem.m_69871_((int)0, (int)0, (int)p_167905_, (int)p_167906_, (int)32992, (int)5121, (ByteBuffer)bytebuffer);
                    screenshot.m_168609_(bytebuffer, j, i, p_167905_, p_167906_);
                }
                screenshot.m_168605_();
            }
            File file1 = screenshot.m_168615_();
            GlUtil.m_166251_((Buffer)bytebuffer);
            MutableComponent component = new TextComponent(file1.getName()).m_130940_(ChatFormatting.UNDERLINE).m_130938_(p_210721_ -> p_210721_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, file1.getAbsolutePath())));
            return new TranslatableComponent("screenshot.success", component);
        }
        catch (Exception exception) {
            f_90982_.warn("Couldn't save screenshot", (Throwable)exception);
            return new TranslatableComponent("screenshot.failure", exception.getMessage());
        }
    }

    public ProfilerFiller m_91307_() {
        return this.f_91026_;
    }

    public Game m_91309_() {
        return this.f_91004_;
    }

    @Nullable
    public StoringChunkProgressListener m_167983_() {
        return this.f_90999_.get();
    }

    public SplashManager m_91310_() {
        return this.f_91046_;
    }

    @Nullable
    public Overlay m_91265_() {
        return this.f_91081_;
    }

    public PlayerSocialManager m_91266_() {
        return this.f_91006_;
    }

    public boolean m_91267_() {
        return false;
    }

    public Window m_91268_() {
        return this.f_90990_;
    }

    public RenderBuffers m_91269_() {
        return this.f_90993_;
    }

    private static Pack createClientPackAdapter(String p_167934_, Component p_167935_, boolean p_167936_, Supplier<PackResources> p_167937_, PackMetadataSection p_167938_, Pack.Position p_167939_, PackSource p_167940_, boolean hidden) {
        int i = p_167938_.getPackFormat(PackType.CLIENT_RESOURCES);
        Supplier<PackResources> supplier = p_167937_;
        if (i <= 3) {
            supplier = Minecraft.m_91330_(p_167937_);
        }
        if (i <= 4) {
            supplier = Minecraft.m_91352_(supplier);
        }
        return new Pack(p_167934_, p_167935_, p_167936_, supplier, p_167938_, PackType.CLIENT_RESOURCES, p_167939_, p_167940_, hidden);
    }

    private static Supplier<PackResources> m_91330_(Supplier<PackResources> p_91331_) {
        return () -> new LegacyPackResourcesAdapter((PackResources)p_91331_.get(), LegacyPackResourcesAdapter.f_118690_);
    }

    private static Supplier<PackResources> m_91352_(Supplier<PackResources> p_91353_) {
        return () -> new PackResourcesAdapterV4((PackResources)p_91353_.get());
    }

    public void m_91312_(int p_91313_) {
        this.f_91051_.m_119410_(p_91313_);
    }

    public ItemColors getItemColors() {
        return this.f_91041_;
    }

    public SearchRegistry getSearchTreeManager() {
        return this.f_90997_;
    }

    public EntityModelSet m_167973_() {
        return this.f_167844_;
    }

    public boolean m_167974_() {
        return this.f_193584_.properties().flag(UserApiService.UserFlag.PROFANITY_FILTER_ENABLED);
    }

    public void m_193588_() {
        this.f_91006_.m_194059_();
    }

    private static /* synthetic */ DataResult lambda$createLevel$35(DynamicOps dynamicops1, JsonElement p_210687_) {
        return WorldGenSettings.f_64600_.parse(dynamicops1, (Object)p_210687_);
    }

    private static /* synthetic */ void lambda$debugClientMetricsStart$23(Consumer p_167947_, Component component) {
        p_167947_.accept(new TranslatableComponent("debug.profiling.stop", component));
    }

    static {
        f_90982_ = LogUtils.getLogger();
        f_91002_ = Util.m_137581_() == Util.OS.OSX;
        f_91055_ = new ResourceLocation("default");
        f_91058_ = new ResourceLocation("uniform");
        f_91059_ = new ResourceLocation("alt");
        f_205119_ = new ResourceLocation("regional_compliancies.json");
        f_90983_ = CompletableFuture.completedFuture(Unit.INSTANCE);
        f_90984_ = new TranslatableComponent("multiplayer.socialInteractions.not_available");
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @OnlyIn(value=Dist.CLIENT)
    public static abstract class ChatStatus
    extends Enum<ChatStatus> {
        public static final /* enum */ ChatStatus ENABLED = new ChatStatus(TextComponent.f_131282_){

            @Override
            public boolean m_142594_(boolean p_168045_) {
                return true;
            }
        };
        public static final /* enum */ ChatStatus DISABLED_BY_OPTIONS = new ChatStatus((Component)new TranslatableComponent("chat.disabled.options").m_130940_(ChatFormatting.RED)){

            @Override
            public boolean m_142594_(boolean p_168051_) {
                return false;
            }
        };
        public static final /* enum */ ChatStatus DISABLED_BY_LAUNCHER = new ChatStatus((Component)new TranslatableComponent("chat.disabled.launcher").m_130940_(ChatFormatting.RED)){

            @Override
            public boolean m_142594_(boolean p_168057_) {
                return p_168057_;
            }
        };
        public static final /* enum */ ChatStatus DISABLED_BY_PROFILE = new ChatStatus((Component)new TranslatableComponent("chat.disabled.profile").m_130940_(ChatFormatting.RED)){

            @Override
            public boolean m_142594_(boolean p_168063_) {
                return p_168063_;
            }
        };
        private final Component f_168027_;
        private static final /* synthetic */ ChatStatus[] $VALUES;

        public static ChatStatus[] values() {
            return (ChatStatus[])$VALUES.clone();
        }

        public static ChatStatus valueOf(String p_168038_) {
            return Enum.valueOf(ChatStatus.class, p_168038_);
        }

        private ChatStatus(Component p_168033_) {
            this.f_168027_ = p_168033_;
        }

        public Component m_168034_() {
            return this.f_168027_;
        }

        public abstract boolean m_142594_(boolean var1);

        private static /* synthetic */ ChatStatus[] m_168036_() {
            return new ChatStatus[]{ENABLED, DISABLED_BY_OPTIONS, DISABLED_BY_LAUNCHER, DISABLED_BY_PROFILE};
        }

        static {
            $VALUES = ChatStatus.m_168036_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static final class ExperimentalDialogType
    extends Enum<ExperimentalDialogType> {
        public static final /* enum */ ExperimentalDialogType NONE = new ExperimentalDialogType();
        public static final /* enum */ ExperimentalDialogType CREATE = new ExperimentalDialogType();
        public static final /* enum */ ExperimentalDialogType BACKUP = new ExperimentalDialogType();
        private static final /* synthetic */ ExperimentalDialogType[] $VALUES;

        public static ExperimentalDialogType[] values() {
            return (ExperimentalDialogType[])$VALUES.clone();
        }

        public static ExperimentalDialogType valueOf(String p_91418_) {
            return Enum.valueOf(ExperimentalDialogType.class, p_91418_);
        }

        private static /* synthetic */ ExperimentalDialogType[] m_168064_() {
            return new ExperimentalDialogType[]{NONE, CREATE, BACKUP};
        }

        static {
            $VALUES = ExperimentalDialogType.m_168064_();
        }
    }
}

