/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.entity.PartEntity;

public interface IForgeEntity
extends ICapabilitySerializable<CompoundTag> {
    private Entity self() {
        return (Entity)this;
    }

    @Override
    default public void deserializeNBT(CompoundTag nbt) {
        this.self().m_20258_(nbt);
    }

    @Override
    default public CompoundTag serializeNBT() {
        CompoundTag ret = new CompoundTag();
        String id = this.self().m_20078_();
        if (id != null) {
            ret.m_128359_("id", this.self().m_20078_());
        }
        return this.self().m_20240_(ret);
    }

    public boolean canUpdate();

    public void canUpdate(boolean var1);

    @Nullable
    public Collection<ItemEntity> captureDrops();

    public Collection<ItemEntity> captureDrops(@Nullable Collection<ItemEntity> var1);

    public CompoundTag getPersistentData();

    default public boolean shouldRiderSit() {
        return true;
    }

    default public ItemStack getPickedResult(HitResult target) {
        ItemStack result = this.self().m_142340_();
        if (result == null) {
            SpawnEggItem egg = ForgeSpawnEggItem.fromEntityType(this.self().m_6095_());
            result = egg != null ? new ItemStack((ItemLike)egg) : ItemStack.f_41583_;
        }
        return result;
    }

    default public boolean canRiderInteract() {
        return false;
    }

    default public boolean canBeRiddenInWater(Entity rider) {
        return this.self().m_6146_();
    }

    public boolean canTrample(BlockState var1, BlockPos var2, float var3);

    default public MobCategory getClassification(boolean forSpawnCount) {
        return this.self().m_6095_().m_20674_();
    }

    public boolean isAddedToWorld();

    public void onAddedToWorld();

    public void onRemovedFromWorld();

    public void revive();

    default public boolean isMultipartEntity() {
        return false;
    }

    @Nullable
    default public PartEntity<?>[] getParts() {
        return null;
    }

    default public float getStepHeight() {
        LivingEntity living;
        AttributeInstance stepHeightAttribute;
        float vanillaStep = this.self().f_19793_;
        Entity entity = this.self();
        if (entity instanceof LivingEntity && (stepHeightAttribute = (living = (LivingEntity)entity).m_21051_(ForgeMod.STEP_HEIGHT_ADDITION.get())) != null) {
            return (float)Math.max(0.0, (double)vanillaStep + stepHeightAttribute.m_22135_());
        }
        return vanillaStep;
    }
}

