/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.geometry;

import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.geometry.IModelGeometryPart;
import net.minecraftforge.client.model.geometry.ISimpleModelGeometry;

public interface IMultipartModelGeometry<T extends IMultipartModelGeometry<T>>
extends ISimpleModelGeometry<T> {
    @Override
    public Collection<? extends IModelGeometryPart> getParts();

    @Override
    public Optional<? extends IModelGeometryPart> getPart(String var1);

    @Override
    default public void addQuads(IModelConfiguration owner, IModelBuilder<?> modelBuilder, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ResourceLocation modelLocation) {
        this.getParts().stream().filter(part -> owner.getPartVisibility((IModelGeometryPart)part)).forEach(part -> part.addQuads(owner, modelBuilder, bakery, spriteGetter, modelTransform, modelLocation));
    }

    @Override
    default public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet combined = Sets.newHashSet();
        for (IModelGeometryPart part : this.getParts()) {
            combined.addAll(part.getTextures(owner, modelGetter, missingTextureErrors));
        }
        return combined;
    }
}

