/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraftforge.fml.loading.moddiscovery.InvalidModFileException;
import net.minecraftforge.forgespi.language.IConfigurable;
import net.minecraftforge.forgespi.language.IModFileInfo;

public class NightConfigWrapper
implements IConfigurable {
    private final UnmodifiableConfig config;
    private IModFileInfo file;

    public NightConfigWrapper(UnmodifiableConfig config) {
        this.config = config;
    }

    NightConfigWrapper setFile(IModFileInfo file) {
        this.file = file;
        return this;
    }

    public <T> Optional<T> getConfigElement(String ... key) {
        return this.config.getOptional(Arrays.asList(key)).map(value -> {
            if (value instanceof UnmodifiableConfig) {
                return ((UnmodifiableConfig)value).valueMap();
            }
            return value;
        });
    }

    public List<? extends IConfigurable> getConfigList(String ... key) {
        List<String> path = Arrays.asList(key);
        if (this.config.contains(path) && !(this.config.get(path) instanceof Collection)) {
            throw new InvalidModFileException("The configuration path " + String.valueOf(path) + " is invalid. Expecting a collection!", this.file);
        }
        Collection nestedConfigs = (Collection)this.config.getOrElse(path, ArrayList::new);
        return nestedConfigs.stream().map(NightConfigWrapper::new).map(cw -> cw.setFile(this.file)).collect(Collectors.toList());
    }
}

