/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.Function;
import net.minecraft.core.QuartPos;
import net.minecraft.data.worldgen.TerrainProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.TerrainShaper;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.NoiseSamplingSettings;
import net.minecraft.world.level.levelgen.NoiseSlider;

public record NoiseSettings(int f_158688_, int f_64508_, NoiseSamplingSettings f_64509_, NoiseSlider f_64510_, NoiseSlider f_64511_, int f_64512_, int f_64513_, TerrainShaper f_189186_) {
    public static final Codec<NoiseSettings> f_64507_ = RecordCodecBuilder.create(p_64536_ -> p_64536_.group((App)Codec.intRange((int)DimensionType.f_156653_, (int)DimensionType.f_156652_).fieldOf("min_y").forGetter(NoiseSettings::f_158688_), (App)Codec.intRange((int)0, (int)DimensionType.f_156651_).fieldOf("height").forGetter(NoiseSettings::f_64508_), (App)NoiseSamplingSettings.f_64489_.fieldOf("sampling").forGetter(NoiseSettings::f_64509_), (App)NoiseSlider.f_189223_.fieldOf("top_slide").forGetter(NoiseSettings::f_64510_), (App)NoiseSlider.f_189223_.fieldOf("bottom_slide").forGetter(NoiseSettings::f_64511_), (App)Codec.intRange((int)1, (int)4).fieldOf("size_horizontal").forGetter(NoiseSettings::f_64512_), (App)Codec.intRange((int)1, (int)4).fieldOf("size_vertical").forGetter(NoiseSettings::f_64513_), (App)TerrainShaper.f_187252_.fieldOf("terrain_shaper").forGetter(NoiseSettings::f_189186_)).apply((Applicative)p_64536_, NoiseSettings::new)).comapFlatMap(NoiseSettings::m_158720_, Function.identity());
    static final NoiseSettings f_209630_ = NoiseSettings.m_212298_(0, 128, new NoiseSamplingSettings(1.0, 3.0, 80.0, 60.0), new NoiseSlider(0.9375, 3, 0), new NoiseSlider(2.5, 4, -1), 1, 2, TerrainProvider.m_194815_());
    static final NoiseSettings f_209631_ = NoiseSettings.m_212298_(0, 128, new NoiseSamplingSettings(2.0, 1.0, 80.0, 160.0), new NoiseSlider(-23.4375, 64, -46), new NoiseSlider(-0.234375, 7, 1), 2, 1, TerrainProvider.m_194818_());
    static final NoiseSettings f_209632_ = NoiseSettings.m_212298_(-64, 192, new NoiseSamplingSettings(1.0, 3.0, 80.0, 60.0), new NoiseSlider(0.9375, 3, 0), new NoiseSlider(2.5, 4, -1), 1, 2, TerrainProvider.m_198384_());
    static final NoiseSettings f_209633_ = NoiseSettings.m_212298_(0, 256, new NoiseSamplingSettings(2.0, 1.0, 80.0, 160.0), new NoiseSlider(-23.4375, 64, -46), new NoiseSlider(-0.234375, 7, 1), 2, 1, TerrainProvider.m_198385_());

    private static DataResult<NoiseSettings> m_158720_(NoiseSettings p_158721_) {
        if (p_158721_.f_158688_() + p_158721_.f_64508_() > DimensionType.f_156652_ + 1) {
            return DataResult.error((String)("min_y + height cannot be higher than: " + (DimensionType.f_156652_ + 1)));
        }
        if (p_158721_.f_64508_() % 16 != 0) {
            return DataResult.error((String)"height has to be a multiple of 16");
        }
        if (p_158721_.f_158688_() % 16 != 0) {
            return DataResult.error((String)"min_y has to be a multiple of 16");
        }
        return DataResult.success((Object)p_158721_);
    }

    public static NoiseSettings m_212298_(int p_212299_, int p_212300_, NoiseSamplingSettings p_212301_, NoiseSlider p_212302_, NoiseSlider p_212303_, int p_212304_, int p_212305_, TerrainShaper p_212306_) {
        NoiseSettings $$8 = new NoiseSettings(p_212299_, p_212300_, p_212301_, p_212302_, p_212303_, p_212304_, p_212305_, p_212306_);
        NoiseSettings.m_158720_($$8).error().ifPresent(p_158719_ -> {
            throw new IllegalStateException(p_158719_.message());
        });
        return $$8;
    }

    static NoiseSettings m_212307_(boolean p_212308_) {
        return NoiseSettings.m_212298_(-64, 384, new NoiseSamplingSettings(1.0, 1.0, 80.0, 160.0), new NoiseSlider(-0.078125, 2, p_212308_ ? 0 : 8), new NoiseSlider(p_212308_ ? 0.4 : 0.1171875, 3, 0), 1, 2, TerrainProvider.m_194816_(p_212308_));
    }

    public int m_189212_() {
        return QuartPos.m_175402_(this.f_64513_());
    }

    public int m_189213_() {
        return QuartPos.m_175402_(this.f_64512_());
    }

    public int m_189216_() {
        return this.f_64508_() / this.m_189212_();
    }

    public int m_189217_() {
        return Mth.m_14042_(this.f_158688_(), this.m_189212_());
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{NoiseSettings.class, "minY;height;noiseSamplingSettings;topSlideSettings;bottomSlideSettings;noiseSizeHorizontal;noiseSizeVertical;terrainShaper", "f_158688_", "f_64508_", "f_64509_", "f_64510_", "f_64511_", "f_64512_", "f_64513_", "f_189186_"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NoiseSettings.class, "minY;height;noiseSamplingSettings;topSlideSettings;bottomSlideSettings;noiseSizeHorizontal;noiseSizeVertical;terrainShaper", "f_158688_", "f_64508_", "f_64509_", "f_64510_", "f_64511_", "f_64512_", "f_64513_", "f_189186_"}, this);
    }

    @Override
    public final boolean equals(Object p_189215_) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NoiseSettings.class, "minY;height;noiseSamplingSettings;topSlideSettings;bottomSlideSettings;noiseSizeHorizontal;noiseSizeVertical;terrainShaper", "f_158688_", "f_64508_", "f_64509_", "f_64510_", "f_64511_", "f_64512_", "f_64513_", "f_189186_"}, this, p_189215_);
    }
}

