/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;

public class ResourceOrTagLocationArgument<T>
implements ArgumentType<Result<T>> {
    private static final Collection<String> f_210943_ = Arrays.asList("foo", "foo:bar", "012", "#skeletons", "#minecraft:skeletons");
    private static final DynamicCommandExceptionType f_210944_ = new DynamicCommandExceptionType(p_210974_ -> new TranslatableComponent("commands.locatebiome.invalid", p_210974_));
    private static final DynamicCommandExceptionType f_210945_ = new DynamicCommandExceptionType(p_210967_ -> new TranslatableComponent("commands.locate.invalid", p_210967_));
    final ResourceKey<? extends Registry<T>> f_210946_;

    public ResourceOrTagLocationArgument(ResourceKey<? extends Registry<T>> p_210949_) {
        this.f_210946_ = p_210949_;
    }

    public static <T> ResourceOrTagLocationArgument<T> m_210968_(ResourceKey<? extends Registry<T>> p_210969_) {
        return new ResourceOrTagLocationArgument<T>(p_210969_);
    }

    private static <T> Result<T> m_210955_(CommandContext<CommandSourceStack> p_210956_, String p_210957_, ResourceKey<Registry<T>> p_210958_, DynamicCommandExceptionType p_210959_) throws CommandSyntaxException {
        Result $$4 = (Result)p_210956_.getArgument(p_210957_, Result.class);
        Optional<Result<T>> $$5 = $$4.m_207209_(p_210958_);
        return $$5.orElseThrow(() -> p_210959_.create((Object)$$4));
    }

    public static Result<Biome> m_210952_(CommandContext<CommandSourceStack> p_210953_, String p_210954_) throws CommandSyntaxException {
        return ResourceOrTagLocationArgument.m_210955_(p_210953_, p_210954_, Registry.f_122885_, f_210944_);
    }

    public static Result<ConfiguredStructureFeature<?, ?>> m_210970_(CommandContext<CommandSourceStack> p_210971_, String p_210972_) throws CommandSyntaxException {
        return ResourceOrTagLocationArgument.m_210955_(p_210971_, p_210972_, Registry.f_122882_, f_210945_);
    }

    public Result<T> parse(StringReader p_210951_) throws CommandSyntaxException {
        if (p_210951_.canRead() && p_210951_.peek() == '#') {
            int $$1 = p_210951_.getCursor();
            try {
                p_210951_.skip();
                ResourceLocation $$2 = ResourceLocation.m_135818_(p_210951_);
                return new TagResult(TagKey.m_203882_(this.f_210946_, $$2));
            }
            catch (CommandSyntaxException $$3) {
                p_210951_.setCursor($$1);
                throw $$3;
            }
        }
        ResourceLocation $$4 = ResourceLocation.m_135818_(p_210951_);
        return new ResourceResult(ResourceKey.m_135785_(this.f_210946_, $$4));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> p_210977_, SuggestionsBuilder p_210978_) {
        Object object = p_210977_.getSource();
        if (object instanceof SharedSuggestionProvider) {
            SharedSuggestionProvider $$2 = (SharedSuggestionProvider)object;
            return $$2.m_212095_(this.f_210946_, SharedSuggestionProvider.ElementSuggestionType.ALL, p_210978_, p_210977_);
        }
        return p_210978_.buildFuture();
    }

    public Collection<String> getExamples() {
        return f_210943_;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static interface Result<T>
    extends Predicate<Holder<T>> {
        public Either<ResourceKey<T>, TagKey<T>> m_207418_();

        public <E> Optional<Result<E>> m_207209_(ResourceKey<? extends Registry<E>> var1);

        public String m_207276_();
    }

    record TagResult<T>(TagKey<T> f_211015_) implements Result<T>
    {
        @Override
        public Either<ResourceKey<T>, TagKey<T>> m_207418_() {
            return Either.right(this.f_211015_);
        }

        @Override
        public <E> Optional<Result<E>> m_207209_(ResourceKey<? extends Registry<E>> p_211022_) {
            return this.f_211015_.m_207647_(p_211022_).map(TagResult::new);
        }

        @Override
        public boolean test(Holder<T> p_211020_) {
            return p_211020_.m_203656_(this.f_211015_);
        }

        @Override
        public String m_207276_() {
            return "#" + this.f_211015_.f_203868_();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TagResult.class, "key", "f_211015_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TagResult.class, "key", "f_211015_"}, this);
        }

        @Override
        public final boolean equals(Object p_211026_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TagResult.class, "key", "f_211015_"}, this, p_211026_);
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((Holder)object);
        }
    }

    record ResourceResult<T>(ResourceKey<T> f_210981_) implements Result<T>
    {
        @Override
        public Either<ResourceKey<T>, TagKey<T>> m_207418_() {
            return Either.left(this.f_210981_);
        }

        @Override
        public <E> Optional<Result<E>> m_207209_(ResourceKey<? extends Registry<E>> p_210988_) {
            return this.f_210981_.m_195975_(p_210988_).map(ResourceResult::new);
        }

        @Override
        public boolean test(Holder<T> p_210986_) {
            return p_210986_.m_203565_(this.f_210981_);
        }

        @Override
        public String m_207276_() {
            return this.f_210981_.m_135782_().toString();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ResourceResult.class, "key", "f_210981_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ResourceResult.class, "key", "f_210981_"}, this);
        }

        @Override
        public final boolean equals(Object p_210992_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ResourceResult.class, "key", "f_210981_"}, this, p_210992_);
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((Holder)object);
        }
    }

    public static class Serializer
    implements ArgumentSerializer<ResourceOrTagLocationArgument<?>> {
        @Override
        public void m_6017_(ResourceOrTagLocationArgument<?> p_211009_, FriendlyByteBuf p_211010_) {
            p_211010_.m_130085_(p_211009_.f_210946_.m_135782_());
        }

        @Override
        public ResourceOrTagLocationArgument<?> m_7813_(FriendlyByteBuf p_211012_) {
            ResourceLocation $$1 = p_211012_.m_130281_();
            return new ResourceOrTagLocationArgument(ResourceKey.m_135788_($$1));
        }

        @Override
        public void m_6964_(ResourceOrTagLocationArgument<?> p_211006_, JsonObject p_211007_) {
            p_211007_.addProperty("registry", p_211006_.f_210946_.m_135782_().toString());
        }

        @Override
        public /* synthetic */ ArgumentType m_7813_(FriendlyByteBuf friendlyByteBuf) {
            return this.m_7813_(friendlyByteBuf);
        }
    }
}

