/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.worldselection;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Hashing;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.screens.AlertScreen;
import net.minecraft.client.gui.screens.BackupConfirmScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.ErrorScreen;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.EditWorldScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.WorldStem;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public class WorldSelectionList
extends ObjectSelectionList<WorldListEntry> {
    static final Logger f_101645_ = LogUtils.getLogger();
    static final DateFormat f_101646_ = new SimpleDateFormat();
    static final ResourceLocation f_101647_ = new ResourceLocation("textures/misc/unknown_server.png");
    static final ResourceLocation f_101648_ = new ResourceLocation("textures/gui/world_selection.png");
    static final Component f_101649_ = new TranslatableComponent("selectWorld.tooltip.fromNewerVersion1").m_130940_(ChatFormatting.RED);
    static final Component f_101650_ = new TranslatableComponent("selectWorld.tooltip.fromNewerVersion2").m_130940_(ChatFormatting.RED);
    static final Component f_101651_ = new TranslatableComponent("selectWorld.tooltip.snapshot1").m_130940_(ChatFormatting.GOLD);
    static final Component f_101652_ = new TranslatableComponent("selectWorld.tooltip.snapshot2").m_130940_(ChatFormatting.GOLD);
    static final Component f_101653_ = new TranslatableComponent("selectWorld.locked").m_130940_(ChatFormatting.RED);
    static final Component f_194113_ = new TranslatableComponent("selectWorld.conversion.tooltip").m_130940_(ChatFormatting.RED);
    private final SelectWorldScreen f_101654_;
    @Nullable
    private List<LevelSummary> f_101655_;

    public WorldSelectionList(SelectWorldScreen p_101658_, Minecraft p_101659_, int p_101660_, int p_101661_, int p_101662_, int p_101663_, int p_101664_, Supplier<String> p_101665_, @Nullable WorldSelectionList p_101666_) {
        super(p_101659_, p_101660_, p_101661_, p_101662_, p_101663_, p_101664_);
        this.f_101654_ = p_101658_;
        if (p_101666_ != null) {
            this.f_101655_ = p_101666_.f_101655_;
        }
        this.m_101676_(p_101665_, false);
    }

    public void m_101676_(Supplier<String> p_101677_, boolean p_101678_) {
        this.m_93516_();
        LevelStorageSource $$2 = this.f_93386_.m_91392_();
        if (this.f_101655_ == null || p_101678_) {
            try {
                this.f_101655_ = $$2.m_78244_();
            }
            catch (LevelStorageException $$3) {
                f_101645_.error("Couldn't load level list", (Throwable)$$3);
                this.f_93386_.m_91152_(new ErrorScreen(new TranslatableComponent("selectWorld.unable_to_load"), new TextComponent($$3.getMessage())));
                return;
            }
            Collections.sort(this.f_101655_);
        }
        if (this.f_101655_.isEmpty()) {
            this.f_93386_.m_91152_(CreateWorldScreen.m_205424_(null));
            return;
        }
        String $$4 = p_101677_.get().toLowerCase(Locale.ROOT);
        for (LevelSummary $$5 : this.f_101655_) {
            if (!$$5.m_78361_().toLowerCase(Locale.ROOT).contains($$4) && !$$5.m_78358_().toLowerCase(Locale.ROOT).contains($$4)) continue;
            this.m_7085_(new WorldListEntry(this, $$5));
        }
    }

    @Override
    protected int m_5756_() {
        return super.m_5756_() + 20;
    }

    @Override
    public int m_5759_() {
        return super.m_5759_() + 50;
    }

    @Override
    protected boolean m_5694_() {
        return this.f_101654_.m_7222_() == this;
    }

    @Override
    public void m_6987_(@Nullable WorldListEntry p_101675_) {
        super.m_6987_(p_101675_);
        this.f_101654_.m_101369_(p_101675_ != null && !p_101675_.f_101695_.m_164916_());
    }

    @Override
    protected void m_6778_(AbstractSelectionList.SelectionDirection p_101673_) {
        this.m_93464_(p_101673_, p_101681_ -> !p_101681_.f_101695_.m_164916_());
    }

    public Optional<WorldListEntry> m_101684_() {
        return Optional.ofNullable((WorldListEntry)this.m_93511_());
    }

    public SelectWorldScreen m_101685_() {
        return this.f_101654_;
    }

    public final class WorldListEntry
    extends ObjectSelectionList.Entry<WorldListEntry>
    implements AutoCloseable {
        private static final int f_170312_ = 32;
        private static final int f_170313_ = 32;
        private static final int f_170314_ = 0;
        private static final int f_170315_ = 32;
        private static final int f_170316_ = 64;
        private static final int f_170317_ = 96;
        private static final int f_170318_ = 0;
        private static final int f_170319_ = 32;
        private final Minecraft f_101693_;
        private final SelectWorldScreen f_101694_;
        final LevelSummary f_101695_;
        private final ResourceLocation f_101696_;
        @Nullable
        private File f_101697_;
        @Nullable
        private final DynamicTexture f_101698_;
        private long f_101699_;

        public WorldListEntry(WorldSelectionList p_101702_, LevelSummary p_101703_) {
            this.f_101694_ = p_101702_.m_101685_();
            this.f_101695_ = p_101703_;
            this.f_101693_ = Minecraft.m_91087_();
            String $$3 = p_101703_.m_78358_();
            this.f_101696_ = new ResourceLocation("minecraft", "worlds/" + Util.m_137483_($$3, ResourceLocation::m_135828_) + "/" + Hashing.sha1().hashUnencodedChars((CharSequence)$$3) + "/icon");
            this.f_101697_ = p_101703_.m_78362_();
            if (!this.f_101697_.isFile()) {
                this.f_101697_ = null;
            }
            this.f_101698_ = this.m_101746_();
        }

        @Override
        public Component m_142172_() {
            TranslatableComponent $$2;
            TranslatableComponent $$0 = new TranslatableComponent("narrator.select.world", this.f_101695_.m_78361_(), new Date(this.f_101695_.m_78366_()), this.f_101695_.m_78368_() ? new TranslatableComponent("gameMode.hardcore") : new TranslatableComponent("gameMode." + this.f_101695_.m_78367_().m_46405_()), this.f_101695_.m_78369_() ? new TranslatableComponent("selectWorld.cheats") : TextComponent.f_131282_, this.f_101695_.m_78370_());
            if (this.f_101695_.m_78375_()) {
                MutableComponent $$1 = CommonComponents.m_178398_($$0, f_101653_);
            } else {
                $$2 = $$0;
            }
            return new TranslatableComponent("narrator.select", $$2);
        }

        @Override
        public void m_6311_(PoseStack p_101721_, int p_101722_, int p_101723_, int p_101724_, int p_101725_, int p_101726_, int p_101727_, int p_101728_, boolean p_101729_, float p_101730_) {
            Object $$10 = this.f_101695_.m_78361_();
            String $$11 = this.f_101695_.m_78358_() + " (" + f_101646_.format(new Date(this.f_101695_.m_78366_())) + ")";
            if (StringUtils.isEmpty((CharSequence)$$10)) {
                $$10 = I18n.m_118938_("selectWorld.world", new Object[0]) + " " + (p_101722_ + 1);
            }
            Component $$12 = this.f_101695_.m_78376_();
            this.f_101693_.f_91062_.m_92883_(p_101721_, (String)$$10, p_101724_ + 32 + 3, p_101723_ + 1, 0xFFFFFF);
            this.f_101693_.f_91062_.m_92883_(p_101721_, $$11, p_101724_ + 32 + 3, p_101723_ + this.f_101693_.f_91062_.f_92710_ + 3, 0x808080);
            this.f_101693_.f_91062_.m_92889_(p_101721_, $$12, p_101724_ + 32 + 3, p_101723_ + this.f_101693_.f_91062_.f_92710_ + this.f_101693_.f_91062_.f_92710_ + 3, 0x808080);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.m_157456_(0, this.f_101698_ != null ? this.f_101696_ : f_101647_);
            RenderSystem.m_69478_();
            GuiComponent.m_93133_(p_101721_, p_101724_, p_101723_, 0.0f, 0.0f, 32, 32, 32, 32);
            RenderSystem.m_69461_();
            if (this.f_101693_.f_91066_.f_92051_ || p_101729_) {
                int $$15;
                RenderSystem.m_157456_(0, f_101648_);
                GuiComponent.m_93172_(p_101721_, p_101724_, p_101723_, p_101724_ + 32, p_101723_ + 32, -1601138544);
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157429_(1.0f, 1.0f, 1.0f, 1.0f);
                int $$13 = p_101727_ - p_101724_;
                boolean $$14 = $$13 < 32;
                int n = $$15 = $$14 ? 32 : 0;
                if (this.f_101695_.m_78375_()) {
                    GuiComponent.m_93133_(p_101721_, p_101724_, p_101723_, 96.0f, $$15, 32, 32, 256, 256);
                    if ($$14) {
                        this.f_101694_.m_101363_(this.f_101693_.f_91062_.m_92923_(f_101653_, 175));
                    }
                } else if (this.f_101695_.m_193020_()) {
                    GuiComponent.m_93133_(p_101721_, p_101724_, p_101723_, 96.0f, $$15, 32, 32, 256, 256);
                    if ($$14) {
                        this.f_101694_.m_101363_(this.f_101693_.f_91062_.m_92923_(f_194113_, 175));
                    }
                } else if (this.f_101695_.m_78372_()) {
                    GuiComponent.m_93133_(p_101721_, p_101724_, p_101723_, 32.0f, $$15, 32, 32, 256, 256);
                    if (this.f_101695_.m_78373_()) {
                        GuiComponent.m_93133_(p_101721_, p_101724_, p_101723_, 96.0f, $$15, 32, 32, 256, 256);
                        if ($$14) {
                            this.f_101694_.m_101363_((List<FormattedCharSequence>)ImmutableList.of((Object)f_101649_.m_7532_(), (Object)f_101650_.m_7532_()));
                        }
                    } else if (!SharedConstants.m_183709_().isStable()) {
                        GuiComponent.m_93133_(p_101721_, p_101724_, p_101723_, 64.0f, $$15, 32, 32, 256, 256);
                        if ($$14) {
                            this.f_101694_.m_101363_((List<FormattedCharSequence>)ImmutableList.of((Object)f_101651_.m_7532_(), (Object)f_101652_.m_7532_()));
                        }
                    }
                } else {
                    GuiComponent.m_93133_(p_101721_, p_101724_, p_101723_, 0.0f, $$15, 32, 32, 256, 256);
                }
            }
        }

        @Override
        public boolean m_6375_(double p_101706_, double p_101707_, int p_101708_) {
            if (this.f_101695_.m_164916_()) {
                return true;
            }
            WorldSelectionList.this.m_6987_(this);
            this.f_101694_.m_101369_(WorldSelectionList.this.m_101684_().isPresent());
            if (p_101706_ - (double)WorldSelectionList.this.m_5747_() <= 32.0) {
                this.m_101704_();
                return true;
            }
            if (Util.m_137550_() - this.f_101699_ < 250L) {
                this.m_101704_();
                return true;
            }
            this.f_101699_ = Util.m_137550_();
            return false;
        }

        public void m_101704_() {
            if (this.f_101695_.m_164916_()) {
                return;
            }
            LevelSummary.BackupStatus $$0 = this.f_101695_.m_164914_();
            if ($$0.m_164931_()) {
                String $$1 = "selectWorld.backupQuestion." + $$0.m_164933_();
                String $$2 = "selectWorld.backupWarning." + $$0.m_164933_();
                TranslatableComponent $$3 = new TranslatableComponent($$1);
                if ($$0.m_164932_()) {
                    $$3.m_130944_(ChatFormatting.BOLD, ChatFormatting.RED);
                }
                TranslatableComponent $$4 = new TranslatableComponent($$2, this.f_101695_.m_78370_(), SharedConstants.m_183709_().getName());
                this.f_101693_.m_91152_(new BackupConfirmScreen(this.f_101694_, (p_101736_, p_101737_) -> {
                    if (p_101736_) {
                        String $$2 = this.f_101695_.m_78358_();
                        try (LevelStorageSource.LevelStorageAccess $$3 = this.f_101693_.m_91392_().m_78260_($$2);){
                            EditWorldScreen.m_101258_($$3);
                        }
                        catch (IOException $$4) {
                            SystemToast.m_94852_(this.f_101693_, $$2);
                            f_101645_.error("Failed to backup level {}", (Object)$$2, (Object)$$4);
                        }
                    }
                    this.m_101744_();
                }, $$3, $$4, false));
            } else if (this.f_101695_.m_78373_()) {
                this.f_101693_.m_91152_(new ConfirmScreen(p_101741_ -> {
                    if (p_101741_) {
                        try {
                            this.m_101744_();
                        }
                        catch (Exception $$1) {
                            f_101645_.error("Failure to open 'future world'", (Throwable)$$1);
                            this.f_101693_.m_91152_(new AlertScreen(() -> this.f_101693_.m_91152_(this.f_101694_), new TranslatableComponent("selectWorld.futureworld.error.title"), new TranslatableComponent("selectWorld.futureworld.error.text")));
                        }
                    } else {
                        this.f_101693_.m_91152_(this.f_101694_);
                    }
                }, new TranslatableComponent("selectWorld.versionQuestion"), new TranslatableComponent("selectWorld.versionWarning", this.f_101695_.m_78370_()), new TranslatableComponent("selectWorld.versionJoinButton"), CommonComponents.f_130656_));
            } else {
                this.m_101744_();
            }
        }

        public void m_101738_() {
            this.f_101693_.m_91152_(new ConfirmScreen(p_170322_ -> {
                if (p_170322_) {
                    this.f_101693_.m_91152_(new ProgressScreen(true));
                    this.m_170323_();
                }
                this.f_101693_.m_91152_(this.f_101694_);
            }, new TranslatableComponent("selectWorld.deleteQuestion"), new TranslatableComponent("selectWorld.deleteWarning", this.f_101695_.m_78361_()), new TranslatableComponent("selectWorld.deleteButton"), CommonComponents.f_130656_));
        }

        public void m_170323_() {
            LevelStorageSource $$0 = this.f_101693_.m_91392_();
            String $$1 = this.f_101695_.m_78358_();
            try (LevelStorageSource.LevelStorageAccess $$2 = $$0.m_78260_($$1);){
                $$2.m_78311_();
            }
            catch (IOException $$3) {
                SystemToast.m_94866_(this.f_101693_, $$1);
                f_101645_.error("Failed to delete world {}", (Object)$$1, (Object)$$3);
            }
            WorldSelectionList.this.m_101676_(() -> this.f_101694_.f_101330_.m_94155_(), true);
        }

        public void m_101739_() {
            String $$0 = this.f_101695_.m_78358_();
            try {
                LevelStorageSource.LevelStorageAccess $$1 = this.f_101693_.m_91392_().m_78260_($$0);
                this.f_101693_.m_91152_(new EditWorldScreen(p_101719_ -> {
                    try {
                        $$1.close();
                    }
                    catch (IOException $$3) {
                        f_101645_.error("Failed to unlock level {}", (Object)$$0, (Object)$$3);
                    }
                    if (p_101719_) {
                        WorldSelectionList.this.m_101676_(() -> this.f_101694_.f_101330_.m_94155_(), true);
                    }
                    this.f_101693_.m_91152_(this.f_101694_);
                }, $$1));
            }
            catch (IOException $$2) {
                SystemToast.m_94852_(this.f_101693_, $$0);
                f_101645_.error("Failed to access level {}", (Object)$$0, (Object)$$2);
                WorldSelectionList.this.m_101676_(() -> this.f_101694_.f_101330_.m_94155_(), true);
            }
        }

        public void m_101743_() {
            this.m_101745_();
            try (LevelStorageSource.LevelStorageAccess $$0 = this.f_101693_.m_91392_().m_78260_(this.f_101695_.m_78358_());
                 WorldStem $$1 = this.f_101693_.m_205152_($$0, false);){
                WorldGenSettings $$2 = $$1.f_206895_().m_5961_();
                Path $$3 = CreateWorldScreen.m_100906_($$0.m_78283_(LevelResource.f_78180_), this.f_101693_);
                if ($$2.m_64670_()) {
                    this.f_101693_.m_91152_(new ConfirmScreen(p_205503_ -> this.f_101693_.m_91152_(p_205503_ ? CreateWorldScreen.m_205426_(this.f_101694_, $$1, $$3) : this.f_101694_), new TranslatableComponent("selectWorld.recreate.customized.title"), new TranslatableComponent("selectWorld.recreate.customized.text"), CommonComponents.f_130659_, CommonComponents.f_130656_));
                } else {
                    this.f_101693_.m_91152_(CreateWorldScreen.m_205426_(this.f_101694_, $$1, $$3));
                }
            }
            catch (Exception $$4) {
                f_101645_.error("Unable to recreate world", (Throwable)$$4);
                this.f_101693_.m_91152_(new AlertScreen(() -> this.f_101693_.m_91152_(this.f_101694_), new TranslatableComponent("selectWorld.recreate.error.title"), new TranslatableComponent("selectWorld.recreate.error.text")));
            }
        }

        private void m_101744_() {
            this.f_101693_.m_91106_().m_120367_(SimpleSoundInstance.m_119752_(SoundEvents.f_12490_, 1.0f));
            if (this.f_101693_.m_91392_().m_78255_(this.f_101695_.m_78358_())) {
                this.m_101745_();
                this.f_101693_.m_91200_(this.f_101695_.m_78358_());
            }
        }

        private void m_101745_() {
            this.f_101693_.m_91346_(new GenericDirtMessageScreen(new TranslatableComponent("selectWorld.data_read")));
        }

        @Nullable
        private DynamicTexture m_101746_() {
            boolean $$0;
            boolean bl = $$0 = this.f_101697_ != null && this.f_101697_.isFile();
            if ($$0) {
                DynamicTexture dynamicTexture;
                FileInputStream $$1 = new FileInputStream(this.f_101697_);
                try {
                    NativeImage $$2 = NativeImage.m_85058_($$1);
                    Validate.validState(($$2.m_84982_() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                    Validate.validState(($$2.m_85084_() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                    DynamicTexture $$3 = new DynamicTexture($$2);
                    this.f_101693_.m_91097_().m_118495_(this.f_101696_, $$3);
                    dynamicTexture = $$3;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            ((InputStream)$$1).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Throwable $$4) {
                        f_101645_.error("Invalid icon for world {}", (Object)this.f_101695_.m_78358_(), (Object)$$4);
                        this.f_101697_ = null;
                        return null;
                    }
                }
                ((InputStream)$$1).close();
                return dynamicTexture;
            }
            this.f_101693_.m_91097_().m_118513_(this.f_101696_);
            return null;
        }

        @Override
        public void close() {
            if (this.f_101698_ != null) {
                this.f_101698_.close();
            }
        }

        public String m_170324_() {
            return this.f_101695_.m_78361_();
        }
    }
}

