/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.worldselection;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.client.gui.screens.worldselection.EditGameRulesScreen;
import net.minecraft.client.gui.screens.worldselection.WorldGenSettingsComponent;
import net.minecraft.client.gui.screens.worldselection.WorldPreset;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.commands.Commands;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.WorldStem;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.FolderRepositorySource;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

public class CreateWorldScreen
extends Screen {
    private static final Logger f_100848_ = LogUtils.getLogger();
    private static final String f_170147_ = "mcworld-";
    private static final Component f_100849_ = new TranslatableComponent("selectWorld.gameMode");
    private static final Component f_100850_ = new TranslatableComponent("selectWorld.enterSeed");
    private static final Component f_100851_ = new TranslatableComponent("selectWorld.seedInfo");
    private static final Component f_100852_ = new TranslatableComponent("selectWorld.enterName");
    private static final Component f_100853_ = new TranslatableComponent("selectWorld.resultFolder");
    private static final Component f_100854_ = new TranslatableComponent("selectWorld.allowCommands.info");
    @Nullable
    private final Screen f_100855_;
    private EditBox f_100856_;
    String f_100857_;
    private SelectedGameMode f_100858_ = SelectedGameMode.SURVIVAL;
    @Nullable
    private SelectedGameMode f_100826_;
    private Difficulty f_170145_ = Difficulty.NORMAL;
    private boolean f_100829_;
    private boolean f_100830_;
    public boolean f_100845_;
    protected DataPackConfig f_100846_;
    @Nullable
    private Path f_100831_;
    @Nullable
    private PackRepository f_100832_;
    private boolean f_170146_;
    private Button f_100834_;
    private CycleButton<SelectedGameMode> f_100835_;
    private CycleButton<Difficulty> f_100836_;
    private Button f_100837_;
    private Button f_100838_;
    private Button f_100839_;
    private CycleButton<Boolean> f_100840_;
    private Component f_100841_;
    private Component f_100842_;
    private String f_100843_;
    private GameRules f_100844_ = new GameRules();
    public final WorldGenSettingsComponent f_100847_;

    public static CreateWorldScreen m_205424_(@Nullable Screen p_205425_) {
        RegistryAccess.Frozen $$1 = RegistryAccess.f_123049_.get();
        return new CreateWorldScreen(p_205425_, DataPackConfig.f_45842_, new WorldGenSettingsComponent($$1, WorldGenSettings.m_190050_($$1), Optional.of(WorldPreset.f_101506_), OptionalLong.empty()));
    }

    public static CreateWorldScreen m_205426_(@Nullable Screen p_205427_, WorldStem p_205428_, @Nullable Path p_205429_) {
        WorldData $$3 = p_205428_.f_206895_();
        LevelSettings $$4 = $$3.m_5926_();
        WorldGenSettings $$5 = $$3.m_5961_();
        RegistryAccess.Frozen $$6 = p_205428_.f_206894_();
        DataPackConfig $$7 = $$4.m_46934_();
        CreateWorldScreen $$8 = new CreateWorldScreen(p_205427_, $$7, new WorldGenSettingsComponent($$6, $$5, WorldPreset.m_101524_($$5), OptionalLong.of($$5.m_64619_())));
        $$8.f_100843_ = $$4.m_46917_();
        $$8.f_100829_ = $$4.m_46932_();
        $$8.f_100830_ = true;
        $$8.f_170145_ = $$4.m_46931_();
        $$8.f_100844_.m_46176_($$4.m_46933_(), null);
        if ($$4.m_46930_()) {
            $$8.f_100858_ = SelectedGameMode.HARDCORE;
        } else if ($$4.m_46929_().m_46409_()) {
            $$8.f_100858_ = SelectedGameMode.SURVIVAL;
        } else if ($$4.m_46929_().m_46408_()) {
            $$8.f_100858_ = SelectedGameMode.CREATIVE;
        }
        $$8.f_100831_ = p_205429_;
        return $$8;
    }

    private CreateWorldScreen(@Nullable Screen p_100861_, DataPackConfig p_100862_, WorldGenSettingsComponent p_100863_) {
        super(new TranslatableComponent("selectWorld.create"));
        this.f_100855_ = p_100861_;
        this.f_100843_ = I18n.m_118938_("selectWorld.newWorld", new Object[0]);
        this.f_100846_ = p_100862_;
        this.f_100847_ = p_100863_;
    }

    @Override
    public void m_96624_() {
        this.f_100856_.m_94120_();
        this.f_100847_.m_101469_();
    }

    @Override
    protected void m_7856_() {
        this.f_96541_.f_91068_.m_90926_(true);
        this.f_100856_ = new EditBox(this.f_96547_, this.f_96543_ / 2 - 100, 60, 200, 20, (Component)new TranslatableComponent("selectWorld.enterName")){

            @Override
            protected MutableComponent m_5646_() {
                return CommonComponents.m_178398_(super.m_5646_(), new TranslatableComponent("selectWorld.resultFolder")).m_130946_(" ").m_130946_(CreateWorldScreen.this.f_100857_);
            }
        };
        this.f_100856_.m_94144_(this.f_100843_);
        this.f_100856_.m_94151_(p_100932_ -> {
            this.f_100843_ = p_100932_;
            this.f_100834_.f_93623_ = !this.f_100856_.m_94155_().isEmpty();
            this.m_100971_();
        });
        this.m_7787_(this.f_100856_);
        int $$0 = this.f_96543_ / 2 - 155;
        int $$1 = this.f_96543_ / 2 + 5;
        this.f_100835_ = this.m_142416_((GuiEventListener & Widget)CycleButton.m_168894_(SelectedGameMode::m_170207_).m_168961_((SelectedGameMode[])new SelectedGameMode[]{SelectedGameMode.SURVIVAL, SelectedGameMode.HARDCORE, SelectedGameMode.CREATIVE}).m_168948_(this.f_100858_).m_168959_(p_170190_ -> AbstractWidget.m_168799_(p_170190_.m_6035_()).m_7220_(CommonComponents.f_178389_).m_7220_(this.f_100841_).m_130946_(" ").m_7220_(this.f_100842_)).m_168936_($$0, 100, 150, 20, f_100849_, (p_170165_, p_170166_) -> this.m_100900_((SelectedGameMode)((Object)p_170166_))));
        this.f_100836_ = this.m_142416_((GuiEventListener & Widget)CycleButton.m_168894_(Difficulty::m_19033_).m_168961_((Difficulty[])Difficulty.values()).m_168948_(this.m_170205_()).m_168936_($$1, 100, 150, 20, new TranslatableComponent("options.difficulty"), (p_170162_, p_170163_) -> {
            this.f_170145_ = p_170163_;
        }));
        this.f_100840_ = this.m_142416_((GuiEventListener & Widget)CycleButton.m_168916_(this.f_100829_ && !this.f_100845_).m_168959_(p_170160_ -> CommonComponents.m_178398_(p_170160_.m_168904_(), new TranslatableComponent("selectWorld.allowCommands.info"))).m_168936_($$0, 151, 150, 20, new TranslatableComponent("selectWorld.allowCommands"), (p_170168_, p_170169_) -> {
            this.f_100830_ = true;
            this.f_100829_ = p_170169_;
        }));
        this.f_100839_ = this.m_142416_(new Button($$1, 151, 150, 20, new TranslatableComponent("selectWorld.dataPacks"), p_170201_ -> this.m_100975_()));
        this.f_100838_ = this.m_142416_(new Button($$0, 185, 150, 20, new TranslatableComponent("selectWorld.gameRules"), p_100928_ -> this.f_96541_.m_91152_(new EditGameRulesScreen(this.f_100844_.m_46202_(), p_170182_ -> {
            this.f_96541_.m_91152_(this);
            p_170182_.ifPresent(p_170156_ -> {
                this.f_100844_ = p_170156_;
            });
        }))));
        this.f_100847_.m_101429_(this, this.f_96541_, this.f_96547_);
        this.f_100837_ = this.m_142416_(new Button($$1, 185, 150, 20, new TranslatableComponent("selectWorld.moreWorldOptions"), p_100897_ -> this.m_170148_()));
        this.f_100834_ = this.m_142416_(new Button($$0, this.f_96544_ - 28, 150, 20, new TranslatableComponent("selectWorld.create"), p_170188_ -> this.m_100972_()));
        this.f_100834_.f_93623_ = !this.f_100843_.isEmpty();
        this.m_142416_(new Button($$1, this.f_96544_ - 28, 150, 20, CommonComponents.f_130656_, p_170158_ -> this.m_100967_()));
        this.m_170204_();
        this.m_94718_(this.f_100856_);
        this.m_100900_(this.f_100858_);
        this.m_100971_();
    }

    private Difficulty m_170205_() {
        return this.f_100858_ == SelectedGameMode.HARDCORE ? Difficulty.HARD : this.f_170145_;
    }

    private void m_100970_() {
        this.f_100841_ = new TranslatableComponent("selectWorld.gameMode." + this.f_100858_.f_101028_ + ".line1");
        this.f_100842_ = new TranslatableComponent("selectWorld.gameMode." + this.f_100858_.f_101028_ + ".line2");
    }

    private void m_100971_() {
        this.f_100857_ = this.f_100856_.m_94155_().trim();
        if (this.f_100857_.isEmpty()) {
            this.f_100857_ = "World";
        }
        try {
            this.f_100857_ = FileUtil.m_133730_(this.f_96541_.m_91392_().m_78257_(), this.f_100857_, "");
        }
        catch (Exception $$0) {
            this.f_100857_ = "World";
            try {
                this.f_100857_ = FileUtil.m_133730_(this.f_96541_.m_91392_().m_78257_(), this.f_100857_, "");
            }
            catch (Exception $$1) {
                throw new RuntimeException("Could not create save folder", $$1);
            }
        }
    }

    @Override
    public void m_7861_() {
        this.f_96541_.f_91068_.m_90926_(false);
    }

    private void m_100972_() {
        this.f_96541_.m_91346_(new GenericDirtMessageScreen(new TranslatableComponent("createWorld.preparing")));
        if (!this.m_100977_()) {
            return;
        }
        this.m_100974_();
        WorldGenSettings $$0 = this.f_100847_.m_101454_(this.f_100845_);
        LevelSettings $$1 = this.m_205447_($$0.m_64668_());
        this.f_96541_.m_205185_(this.f_100857_, $$1, this.f_100847_.m_205473_(), $$0);
    }

    private LevelSettings m_205447_(boolean p_205448_) {
        String $$1 = this.f_100856_.m_94155_().trim();
        if (p_205448_) {
            GameRules $$2 = new GameRules();
            $$2.m_46170_(GameRules.f_46140_).m_46246_(false, null);
            return new LevelSettings($$1, GameType.SPECTATOR, false, Difficulty.PEACEFUL, true, $$2, DataPackConfig.f_45842_);
        }
        return new LevelSettings($$1, this.f_100858_.f_101029_, this.f_100845_, this.m_170205_(), this.f_100829_ && !this.f_100845_, this.f_100844_, this.f_100846_);
    }

    private void m_170148_() {
        this.m_170196_(!this.f_170146_);
    }

    private void m_100900_(SelectedGameMode p_100901_) {
        if (!this.f_100830_) {
            this.f_100829_ = p_100901_ == SelectedGameMode.CREATIVE;
            this.f_100840_.m_168892_(this.f_100829_);
        }
        if (p_100901_ == SelectedGameMode.HARDCORE) {
            this.f_100845_ = true;
            this.f_100840_.f_93623_ = false;
            this.f_100840_.m_168892_(false);
            this.f_100847_.m_170291_();
            this.f_100836_.m_168892_(Difficulty.HARD);
            this.f_100836_.f_93623_ = false;
        } else {
            this.f_100845_ = false;
            this.f_100840_.f_93623_ = true;
            this.f_100840_.m_168892_(this.f_100829_);
            this.f_100847_.m_170292_();
            this.f_100836_.m_168892_(this.f_170145_);
            this.f_100836_.f_93623_ = true;
        }
        this.f_100858_ = p_100901_;
        this.m_100970_();
    }

    public void m_170204_() {
        this.m_170196_(this.f_170146_);
    }

    private void m_170196_(boolean p_170197_) {
        this.f_170146_ = p_170197_;
        this.f_100835_.f_93624_ = !p_170197_;
        boolean bl = this.f_100836_.f_93624_ = !p_170197_;
        if (this.f_100847_.m_101403_()) {
            this.f_100839_.f_93624_ = false;
            this.f_100835_.f_93623_ = false;
            if (this.f_100826_ == null) {
                this.f_100826_ = this.f_100858_;
            }
            this.m_100900_(SelectedGameMode.DEBUG);
            this.f_100840_.f_93624_ = false;
        } else {
            this.f_100835_.f_93623_ = true;
            if (this.f_100826_ != null) {
                this.m_100900_(this.f_100826_);
            }
            this.f_100840_.f_93624_ = !p_170197_;
            this.f_100839_.f_93624_ = !p_170197_;
        }
        this.f_100847_.m_170287_(p_170197_);
        this.f_100856_.m_94194_(!p_170197_);
        if (p_170197_) {
            this.f_100837_.m_93666_(CommonComponents.f_130655_);
        } else {
            this.f_100837_.m_93666_(new TranslatableComponent("selectWorld.moreWorldOptions"));
        }
        this.f_100838_.f_93624_ = !p_170197_;
    }

    @Override
    public boolean m_7933_(int p_100875_, int p_100876_, int p_100877_) {
        if (super.m_7933_(p_100875_, p_100876_, p_100877_)) {
            return true;
        }
        if (p_100875_ == 257 || p_100875_ == 335) {
            this.m_100972_();
            return true;
        }
        return false;
    }

    @Override
    public void m_7379_() {
        if (this.f_170146_) {
            this.m_170196_(false);
        } else {
            this.m_100967_();
        }
    }

    public void m_100967_() {
        this.f_96541_.m_91152_(this.f_100855_);
        this.m_100974_();
    }

    private void m_100974_() {
        if (this.f_100832_ != null) {
            this.f_100832_.close();
        }
        this.m_100976_();
    }

    @Override
    public void m_6305_(PoseStack p_100890_, int p_100891_, int p_100892_, float p_100893_) {
        this.m_7333_(p_100890_);
        CreateWorldScreen.m_93215_(p_100890_, this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, -1);
        if (this.f_170146_) {
            CreateWorldScreen.m_93243_(p_100890_, this.f_96547_, f_100850_, this.f_96543_ / 2 - 100, 47, -6250336);
            CreateWorldScreen.m_93243_(p_100890_, this.f_96547_, f_100851_, this.f_96543_ / 2 - 100, 85, -6250336);
            this.f_100847_.m_6305_(p_100890_, p_100891_, p_100892_, p_100893_);
        } else {
            CreateWorldScreen.m_93243_(p_100890_, this.f_96547_, f_100852_, this.f_96543_ / 2 - 100, 47, -6250336);
            CreateWorldScreen.m_93243_(p_100890_, this.f_96547_, new TextComponent("").m_7220_(f_100853_).m_130946_(" ").m_130946_(this.f_100857_), this.f_96543_ / 2 - 100, 85, -6250336);
            this.f_100856_.m_6305_(p_100890_, p_100891_, p_100892_, p_100893_);
            CreateWorldScreen.m_93243_(p_100890_, this.f_96547_, this.f_100841_, this.f_96543_ / 2 - 150, 122, -6250336);
            CreateWorldScreen.m_93243_(p_100890_, this.f_96547_, this.f_100842_, this.f_96543_ / 2 - 150, 134, -6250336);
            if (this.f_100840_.f_93624_) {
                CreateWorldScreen.m_93243_(p_100890_, this.f_96547_, f_100854_, this.f_96543_ / 2 - 150, 172, -6250336);
            }
        }
        super.m_6305_(p_100890_, p_100891_, p_100892_, p_100893_);
    }

    @Override
    protected <T extends GuiEventListener & NarratableEntry> T m_7787_(T p_100948_) {
        return super.m_7787_(p_100948_);
    }

    @Override
    protected <T extends GuiEventListener & Widget> T m_142416_(T p_170199_) {
        return super.m_142416_(p_170199_);
    }

    @Nullable
    protected Path m_100968_() {
        if (this.f_100831_ == null) {
            try {
                this.f_100831_ = Files.createTempDirectory(f_170147_, new FileAttribute[0]);
            }
            catch (IOException $$0) {
                f_100848_.warn("Failed to create temporary dir", (Throwable)$$0);
                SystemToast.m_94875_(this.f_96541_, this.f_100857_);
                this.m_100967_();
            }
        }
        return this.f_100831_;
    }

    private void m_100975_() {
        Pair<File, PackRepository> $$0 = this.m_100871_();
        if ($$0 != null) {
            this.f_96541_.m_91152_(new PackSelectionScreen(this, (PackRepository)$$0.getSecond(), this::m_100878_, (File)$$0.getFirst(), new TranslatableComponent("dataPack.title")));
        }
    }

    private void m_100878_(PackRepository p_100879_) {
        ImmutableList $$1 = ImmutableList.copyOf(p_100879_.m_10523_());
        List $$2 = (List)p_100879_.m_10514_().stream().filter(arg_0 -> CreateWorldScreen.m_170178_((List)$$1, arg_0)).collect(ImmutableList.toImmutableList());
        DataPackConfig $$3 = new DataPackConfig((List<String>)$$1, $$2);
        if ($$1.equals(this.f_100846_.m_45850_())) {
            this.f_100846_ = $$3;
            return;
        }
        this.f_96541_.m_6937_(() -> this.f_96541_.m_91152_(new GenericDirtMessageScreen(new TranslatableComponent("dataPack.validation.working"))));
        ((CompletableFuture)WorldStem.m_206911_(new WorldStem.InitConfig(p_100879_, Commands.CommandSelection.INTEGRATED, 2, false), () -> $$3, (p_205414_, p_205415_) -> {
            RegistryAccess $$2 = this.f_100847_.m_205473_();
            RegistryAccess.Writable $$3 = RegistryAccess.m_206197_();
            RegistryOps $$4 = RegistryOps.m_206821_(JsonOps.INSTANCE, $$2);
            RegistryOps $$5 = RegistryOps.m_206813_(JsonOps.INSTANCE, $$3, p_205414_);
            DataResult $$6 = WorldGenSettings.f_64600_.encodeStart($$4, (Object)this.f_100847_.m_101454_(this.f_100845_)).flatMap(p_205423_ -> WorldGenSettings.f_64600_.parse($$5, p_205423_));
            WorldGenSettings $$7 = (WorldGenSettings)$$6.getOrThrow(false, Util.m_137489_("Error parsing worldgen settings after loading data packs: ", arg_0 -> ((Logger)f_100848_).error(arg_0)));
            LevelSettings $$8 = this.m_205447_($$7.m_64668_());
            return Pair.of((Object)new PrimaryLevelData($$8, $$7, $$6.lifecycle()), (Object)$$3.m_203557_());
        }, Util.m_183991_(), this.f_96541_).thenAcceptAsync(p_205420_ -> {
            this.f_100846_ = $$3;
            this.f_100847_.m_205471_((WorldStem)p_205420_);
            p_205420_.close();
        }, (Executor)this.f_96541_)).handle((p_205431_, p_205432_) -> {
            if (p_205432_ != null) {
                f_100848_.warn("Failed to validate datapack", p_205432_);
                this.f_96541_.m_6937_(() -> this.f_96541_.m_91152_(new ConfirmScreen(p_205450_ -> {
                    if (p_205450_) {
                        this.m_100975_();
                    } else {
                        this.f_100846_ = DataPackConfig.f_45842_;
                        this.f_96541_.m_91152_(this);
                    }
                }, new TranslatableComponent("dataPack.validation.failed"), TextComponent.f_131282_, new TranslatableComponent("dataPack.validation.back"), new TranslatableComponent("dataPack.validation.reset"))));
            } else {
                this.f_96541_.m_6937_(() -> this.f_96541_.m_91152_(this));
            }
            return null;
        });
    }

    private void m_100976_() {
        if (this.f_100831_ != null) {
            try (Stream<Path> $$0 = Files.walk(this.f_100831_, new FileVisitOption[0]);){
                $$0.sorted(Comparator.reverseOrder()).forEach(p_205443_ -> {
                    try {
                        Files.delete(p_205443_);
                    }
                    catch (IOException $$1) {
                        f_100848_.warn("Failed to remove temporary file {}", p_205443_, (Object)$$1);
                    }
                });
            }
            catch (IOException $$1) {
                f_100848_.warn("Failed to list temporary dir {}", (Object)this.f_100831_);
            }
            this.f_100831_ = null;
        }
    }

    private static void m_100912_(Path p_100913_, Path p_100914_, Path p_100915_) {
        try {
            Util.m_137563_(p_100913_, p_100914_, p_100915_);
        }
        catch (IOException $$3) {
            f_100848_.warn("Failed to copy datapack file from {} to {}", (Object)p_100915_, (Object)p_100914_);
            throw new OperationFailedException($$3);
        }
    }

    private boolean m_100977_() {
        if (this.f_100831_ != null) {
            try (LevelStorageSource.LevelStorageAccess $$0 = this.f_96541_.m_91392_().m_78260_(this.f_100857_);
                 Stream<Path> $$1 = Files.walk(this.f_100831_, new FileVisitOption[0]);){
                Path $$2 = $$0.m_78283_(LevelResource.f_78180_);
                Files.createDirectories($$2, new FileAttribute[0]);
                $$1.filter(p_205434_ -> !p_205434_.equals(this.f_100831_)).forEach(p_205446_ -> CreateWorldScreen.m_100912_(this.f_100831_, $$2, p_205446_));
            }
            catch (IOException | OperationFailedException $$3) {
                f_100848_.warn("Failed to copy datapacks to world {}", (Object)this.f_100857_, (Object)$$3);
                SystemToast.m_94875_(this.f_96541_, this.f_100857_);
                this.m_100967_();
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static Path m_100906_(Path p_100907_, Minecraft p_100908_) {
        MutableObject $$2 = new MutableObject();
        try (Stream<Path> $$3 = Files.walk(p_100907_, new FileVisitOption[0]);){
            $$3.filter(p_205437_ -> !p_205437_.equals(p_100907_)).forEach(p_205441_ -> {
                Path $$3 = (Path)$$2.getValue();
                if ($$3 == null) {
                    try {
                        $$3 = Files.createTempDirectory(f_170147_, new FileAttribute[0]);
                    }
                    catch (IOException $$4) {
                        f_100848_.warn("Failed to create temporary dir");
                        throw new OperationFailedException($$4);
                    }
                    $$2.setValue((Object)$$3);
                }
                CreateWorldScreen.m_100912_(p_100907_, $$3, p_205441_);
            });
        }
        catch (IOException | OperationFailedException $$4) {
            f_100848_.warn("Failed to copy datapacks from world {}", (Object)p_100907_, (Object)$$4);
            SystemToast.m_94875_(p_100908_, p_100907_.toString());
            return null;
        }
        return (Path)$$2.getValue();
    }

    @Nullable
    private Pair<File, PackRepository> m_100871_() {
        Path $$0 = this.m_100968_();
        if ($$0 != null) {
            File $$1 = $$0.toFile();
            if (this.f_100832_ == null) {
                this.f_100832_ = new PackRepository(PackType.SERVER_DATA, new ServerPacksSource(), new FolderRepositorySource($$1, PackSource.f_10527_));
                this.f_100832_.m_10506_();
            }
            this.f_100832_.m_10509_(this.f_100846_.m_45850_());
            return Pair.of((Object)$$1, (Object)this.f_100832_);
        }
        return null;
    }

    private static /* synthetic */ boolean m_170178_(List p_170179_, String p_170180_) {
        return !p_170179_.contains(p_170180_);
    }

    static final class SelectedGameMode
    extends Enum<SelectedGameMode> {
        public static final /* enum */ SelectedGameMode SURVIVAL = new SelectedGameMode("survival", GameType.SURVIVAL);
        public static final /* enum */ SelectedGameMode HARDCORE = new SelectedGameMode("hardcore", GameType.SURVIVAL);
        public static final /* enum */ SelectedGameMode CREATIVE = new SelectedGameMode("creative", GameType.CREATIVE);
        public static final /* enum */ SelectedGameMode DEBUG = new SelectedGameMode("spectator", GameType.SPECTATOR);
        final String f_101028_;
        final GameType f_101029_;
        private final Component f_170206_;
        private static final /* synthetic */ SelectedGameMode[] $VALUES;

        public static SelectedGameMode[] values() {
            return (SelectedGameMode[])$VALUES.clone();
        }

        public static SelectedGameMode valueOf(String p_101042_) {
            return Enum.valueOf(SelectedGameMode.class, p_101042_);
        }

        private SelectedGameMode(String p_101035_, GameType p_101036_) {
            this.f_101028_ = p_101035_;
            this.f_101029_ = p_101036_;
            this.f_170206_ = new TranslatableComponent("selectWorld.gameMode." + p_101035_);
        }

        public Component m_170207_() {
            return this.f_170206_;
        }

        private static /* synthetic */ SelectedGameMode[] m_170208_() {
            return new SelectedGameMode[]{SURVIVAL, HARDCORE, CREATIVE, DEBUG};
        }

        static {
            $VALUES = SelectedGameMode.m_170208_();
        }
    }

    static class OperationFailedException
    extends RuntimeException {
        public OperationFailedException(Throwable p_101023_) {
            super(p_101023_);
        }
    }
}

