/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installertools;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.stream.Collectors;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import net.minecraftforge.installertools.Task;

public class ExtractFiles
extends Task {
    @Override
    public void process(String[] args) throws IOException {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec archiveO = parser.accepts("archive", "The archive").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec fromO = parser.accepts("from", "File in the archive to extract").withRequiredArg().ofType(String.class).required();
        ArgumentAcceptingOptionSpec toO = parser.accepts("to", "Path to extract file to").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec optionalO = parser.accepts("optional", "Optional paths to extract files to only if they don't already exist").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec execsO = parser.accepts("execs", "A file to set the executable flag on").withRequiredArg().ofType(File.class);
        try {
            int x;
            OptionSet options = parser.parse(args);
            File archive = (File)options.valueOf((OptionSpec)archiveO);
            List from = options.valuesOf((OptionSpec)fromO);
            List to = options.valuesOf((OptionSpec)toO);
            if (from.size() != to.size()) {
                throw new IllegalArgumentException("Invalid arguments, must have matching from/to set");
            }
            List execs = options.valuesOf((OptionSpec)execsO);
            List optional = options.valuesOf((OptionSpec)optionalO).stream().map(File::getAbsolutePath).collect(Collectors.toList());
            this.log("Archive: " + archive);
            for (x = 0; x < from.size(); ++x) {
                this.log("Extract: " + (String)from.get(x));
                this.log("         " + to.get(x));
            }
            for (x = 0; x < execs.size(); ++x) {
                this.log("Exec:    " + execs.get(x));
            }
            if (!archive.exists()) {
                this.error("Could not find archive: " + archive);
            }
            try (FileSystem fs = FileSystems.newFileSystem(archive.toPath(), null);){
                for (int x2 = 0; x2 < from.size(); ++x2) {
                    File toF;
                    Path path = fs.getPath((String)from.get(x2), new String[0]);
                    if (!Files.exists(path, new LinkOption[0])) {
                        this.log("Could not find file in archive: " + (String)from.get(x2));
                    }
                    if (!(toF = (File)to.get(x2)).getParentFile().exists() && !toF.getParentFile().mkdirs()) {
                        this.error("Couldn't make parent directory: " + toF.getParentFile().getAbsolutePath());
                    }
                    if (optional.contains(toF.getAbsolutePath()) && toF.exists()) continue;
                    Files.copy(path, toF.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            for (File exec : execs) {
                if (exec.setExecutable(true)) continue;
                this.log("Couldn't set executable bit for file: " + exec.getAbsolutePath());
            }
        }
        catch (OptionException e) {
            parser.printHelpOn((OutputStream)System.out);
            e.printStackTrace();
        }
    }
}

